/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.sonoair;

import com.sun.javafx.menu.MenuBase;
import com.sun.javafx.scene.control.GlobalMenuAdapter;
import com.sun.javafx.tk.Toolkit;
import eu.mihosoft.sonoair.RedirectableStream;
import eu.mihosoft.vrl.base.VJarUtil;
import eu.mihosoft.vrl.base.VSysUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import nl.revolution.sonos.api.ZonePlayer;
import nl.revolution.sonos.api.ZonePlayers;

public class SonoAir
extends Application {
    private File baseDir;
    private ListView<String> deviceView;
    private Stage primaryStage;
    private RedirectableStream outStream;
    private TextArea outputArea;
    private static final String VERSION = "1.0 (BETA 3.1)";
    private StringProperty btnTextProperty;
    private StringProperty windowTitleProperty;
    private DoubleProperty dividerProperty;
    private ZonePlayers zonePlayers;
    private Process process;

    public void start(Stage primaryStage) {
        new Thread(() -> {
            this.zonePlayers = ZonePlayers.discover();
        }).start();
        this.outputArea = new TextArea();
        this.outputArea.setMinHeight(0.0);
        this.outputArea.getStyleClass().add((Object)"output");
        this.outputArea.setWrapText(true);
        this.outStream = new RedirectableStream((OutputStream)System.out, this.outputArea);
        this.outStream.setRedirectToStdOut(true);
        this.outStream.setRedirectToUi(true);
        this.deviceView = new ListView();
        this.deviceView.setCellFactory(param -> {
            ListCell<String> cell = new ListCell<String>(){
                StackPane pane = new StackPane();
                Label label = new Label();
                Button editBtn = new Button("\uf013");
                {
                    this.label.getStyleClass().add((Object)"device-label");
                    this.pane.getChildren().addAll((Object[])new Node[]{this.label, this.editBtn});
                    this.setOnMouseClicked(me -> {
                        if (me.getClickCount() == 2 && me.getButton() == MouseButton.PRIMARY && !this.getText().trim().isEmpty()) {
                            SonoAir.this.openControlView((Node)this, ((String)this.getItem()).trim());
                        }
                    });
                    this.editBtn.setOnAction(ae -> SonoAir.this.openControlView((Node)this, ((String)this.getItem()).trim()));
                    this.editBtn.setFont(Font.loadFont((String)SonoAir.class.getResource("/font/fontawesome-webfont.ttf").toExternalForm(), (double)14.0));
                    StackPane.setAlignment((Node)this.label, (Pos)Pos.CENTER);
                    StackPane.setAlignment((Node)this.editBtn, (Pos)Pos.CENTER_RIGHT);
                }

                protected void updateItem(String item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    this.setText(null);
                    if (empty || item == null || item.isEmpty()) {
                        this.setGraphic(null);
                    } else {
                        this.setGraphic((Node)this.pane);
                    }
                    this.label.setText(item);
                }
            };
            cell.setAlignment(Pos.CENTER);
            return cell;
        });
        Label label = new Label("Devices:");
        label.getStyleClass().add((Object)"title");
        label.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER);
        Button donateButton = new Button();
        donateButton.getStyleClass().add((Object)"paypal-donate-btn");
        donateButton.setMinWidth(120.0);
        donateButton.setMinHeight(40.0);
        donateButton.setOnAction(e -> this.showDonationPage());
        BorderPane mainUI = new BorderPane();
        StackPane p = new StackPane(new Node[]{donateButton});
        AnchorPane.setTopAnchor((Node)p, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)p, (Double)0.0);
        AnchorPane aPane = new AnchorPane(new Node[]{label, p});
        StackPane.setAlignment((Node)donateButton, (Pos)Pos.CENTER);
        AnchorPane.setLeftAnchor((Node)label, (Double)0.0);
        AnchorPane.setRightAnchor((Node)label, (Double)0.0);
        mainUI.setTop((Node)aPane);
        mainUI.getStyleClass().add((Object)"background");
        mainUI.setSnapToPixel(true);
        mainUI.setCenter(this.deviceView);
        Button btn = new Button();
        this.btnTextProperty = btn.textProperty();
        btn.getStyleClass().add((Object)"restart-btn");
        btn.setText("Stop SonoAir");
        btn.setOnAction(event -> {
            if (!this.isAirsonosRunning()) {
                this.runAirSonosInNewThread();
                this.btnTextProperty.set((Object)"Stop SonoAir");
            } else {
                this.btnTextProperty.set((Object)"Start SonoAir");
                this.stopAirSonnos();
            }
        });
        StackPane btnPane = new StackPane(new Node[]{btn});
        BorderPane.setAlignment((Node)btnPane, (Pos)Pos.CENTER);
        btnPane.getStyleClass().add((Object)"btn-pane");
        mainUI.setBottom((Node)btnPane);
        mainUI.setMinHeight(215.0);
        SplitPane root = new SplitPane();
        root.getStyleClass().add((Object)"split-pane");
        root.setOrientation(Orientation.VERTICAL);
        root.getItems().addAll((Object[])new Node[]{mainUI, this.outputArea});
        root.setDividerPositions(new double[]{1.0});
        this.dividerProperty = ((SplitPane.Divider)root.getDividers().get(0)).positionProperty();
        MenuBar menuBar = new MenuBar();
        menuBar.setUseSystemMenuBar(true);
        Menu helpMenu = new Menu("Help");
        MenuItem aboutItem = new MenuItem("About SonoAir");
        aboutItem.setOnAction(e -> this.getHostServices().showDocument("http://sonoair.mihosoft.eu"));
        helpMenu.getItems().add((Object)aboutItem);
        menuBar.getMenus().add((Object)helpMenu);
        if (VSysUtil.isMacOSX()) {
            ArrayList<MenuBase> menus = new ArrayList<MenuBase>();
            menus.add(GlobalMenuAdapter.adapt((Menu)helpMenu));
            Toolkit.getToolkit().getSystemMenu().setMenus(menus);
        }
        Scene scene = new Scene((Parent)root, 650.0, 400.0);
        scene.getStylesheets().add((Object)"/eu/mihosoft/sonoair/maininterface.css");
        this.baseDir = VJarUtil.getClassLocation(SonoAir.class).getAbsoluteFile().getParentFile();
        this.primaryStage = primaryStage;
        this.windowTitleProperty = primaryStage.titleProperty();
        this.windowTitleProperty.set((Object)"SonoAir 1.0 (BETA 3.1)");
        primaryStage.setScene(scene);
        primaryStage.setResizable(false);
        primaryStage.initStyle(StageStyle.UNIFIED);
        primaryStage.show();
        this.runAirSonosInNewThread();
    }

    private void openControlView(Node n, String deviceName) {
        System.out.println("name: " + deviceName);
        ZonePlayer zone = this.zonePlayers.get(deviceName, 3000);
        BorderPane controlRoot = new BorderPane();
        controlRoot.getStyleClass().add((Object)"dev-control-background");
        Label label = new Label("Control " + deviceName);
        label.getStyleClass().add((Object)"device-title");
        label.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER);
        controlRoot.setTop((Node)label);
        Button doneBtn = new Button();
        doneBtn.getStyleClass().add((Object)"restart-btn");
        doneBtn.setText("Done");
        doneBtn.setAlignment(Pos.CENTER);
        doneBtn.setStyle("-fx-indent: 5 5 5 5;");
        doneBtn.setPrefHeight(20.0);
        BorderPane.setAlignment((Node)doneBtn, (Pos)Pos.CENTER);
        VBox controllerBox = new VBox();
        controllerBox.setPadding(new Insets(20.0, 0.0, 0.0, 0.0));
        controlRoot.setCenter((Node)controllerBox);
        Slider volumeSlider = new Slider();
        volumeSlider.setValue((double)zone.getVolume());
        volumeSlider.setOnMouseReleased(me -> {
            if (me.getButton() == MouseButton.PRIMARY) {
                zone.setVolume((int)volumeSlider.getValue());
            }
        });
        VBox.setVgrow((Node)volumeSlider, (Priority)Priority.ALWAYS);
        Label volumeLabel = new Label("Volume");
        volumeLabel.setAlignment(Pos.CENTER);
        volumeLabel.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)volumeLabel, (Priority)Priority.ALWAYS);
        volumeLabel.getStyleClass().add((Object)"control-label");
        VBox sliderContainer = new VBox(new Node[]{volumeLabel, volumeSlider});
        controllerBox.getChildren().add((Object)sliderContainer);
        ToggleButton ledToggleButton = new ToggleButton("");
        ledToggleButton.getStyleClass().add((Object)"led-btn");
        ledToggleButton.setMinHeight(20.0);
        ledToggleButton.setPrefHeight(20.0);
        ledToggleButton.setMaxHeight(20.0);
        ledToggleButton.setSelected(zone.isLedEnabled());
        ledToggleButton.selectedProperty().addListener((ov, oldV, newV) -> zone.setLedEnabled(newV.booleanValue()));
        Label ledLabel = new Label("LED");
        ledLabel.getStyleClass().add((Object)"control-label");
        controllerBox.getChildren().add((Object)new StackPane(new Node[]{ledLabel}));
        controllerBox.getChildren().add((Object)new StackPane(new Node[]{ledToggleButton}));
        Stage stage = new Stage(StageStyle.TRANSPARENT);
        controlRoot.setBottom((Node)doneBtn);
        doneBtn.setOnAction(ae -> stage.close());
        Scene scene = new Scene((Parent)controlRoot, 400.0, 200.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        scene.getStylesheets().add((Object)"/eu/mihosoft/sonoair/maininterface.css");
        stage.initOwner((Window)this.primaryStage);
        stage.initModality(Modality.WINDOW_MODAL);
        stage.setTitle("Control Device: " + deviceName);
        stage.setScene(scene);
        stage.setResizable(false);
        stage.setX(this.primaryStage.getX() + this.primaryStage.getWidth() / 2.0 - 400.0);
        stage.setY(this.primaryStage.getY() + this.primaryStage.getHeight() / 2.0 - 200.0);
        stage.setOpacity(0.98);
        stage.show();
        stage.setX(this.primaryStage.getX() + this.primaryStage.getWidth() / 2.0 - stage.getWidth() / 2.0);
        stage.setY(this.primaryStage.getY() + this.primaryStage.getHeight() / 2.0 - stage.getHeight() / 2.0);
    }

    private void showDonationPage() {
        Stage donationStage = new Stage(StageStyle.UNIFIED);
        WebView view = new WebView();
        view.getEngine().load("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=WQC8SVJ2P7PNG");
        Scene scene = new Scene((Parent)view, 800.0, 600.0);
        donationStage.setScene(scene);
        donationStage.setTitle("Dotate");
        donationStage.initOwner((Window)this.primaryStage);
        donationStage.initModality(Modality.WINDOW_MODAL);
        donationStage.show();
    }

    private void runAirSonosInNewThread() {
        Thread t = new Thread(() -> this.runAirSonos());
        t.start();
    }

    public void stop() throws Exception {
        this.stopAirSonnos();
        System.exit(0);
    }

    private boolean isAirsonosRunning() {
        return this.process != null;
    }

    private void runAirSonos() {
        this.dividerProperty.set(1.0);
        this.outputArea.setText("");
        this.outStream.println("SonoAir v1.0 (BETA 3.1)");
        this.outStream.println("Copyright (c) 2015 Michael Hoffer <info@michaelhoffer.de>");
        this.outStream.println("--------------------------------------------------------------");
        this.outStream.println("-> using node-v0.10.28-darwin-x64");
        this.outStream.println("-> using airsonos by Stephen Wan");
        this.outStream.println("   see https://github.com/stephen/airsonos/blob/master/LICENSE");
        this.outStream.print("-> starting airsonos module...");
        if (this.isAirsonosRunning()) {
            this.stopAirSonnos();
        }
        ProcessBuilder builder = new ProcessBuilder(this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/node", this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/airsonos");
        builder.redirectErrorStream(true);
        try {
            String line;
            String execLine;
            ProcessBuilder execBuilder = new ProcessBuilder("chmod", "a+x", this.baseDir.getPath() + "/resources/osx/node-v0.10.28-darwin-x64/bin/node");
            builder.redirectErrorStream(true);
            Process makeExecutable = execBuilder.start();
            BufferedReader executableReader = new BufferedReader(new InputStreamReader(makeExecutable.getInputStream()));
            while ((execLine = executableReader.readLine()) != null) {
            }
            this.process = builder.start();
            this.outStream.println(" [done]\n--------------------------------------------------------------");
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Setting up SonoAir for")) {
                    this.outStream.println(line);
                    String devName = line.replace("Setting up SonoAir for ", "").replaceAll("\\{.*\\}", "");
                    this.addDeviceNotification(devName);
                    continue;
                }
                if (line.startsWith("Searching for Sonos devices on network")) {
                    this.outStream.println(line);
                    this.scanDevies();
                    continue;
                }
                if (line.contains("Warning! Codec not supported") || line.contains("AirSonos currently does not support codecs") || line.contains("Progress on this issue: https://github.com/stephen/nodetunes/issues/1")) {
                    if (this.outputArea.getText().contains("SonoAir does not support the requested codec.")) continue;
                    this.outStream.println("ERROR:    SonoAir does not support the requested codec.");
                    this.outStream.println("SOLUTION: select SonoAir audio sorce from menu bar (ALT + Primary Mousebutton)");
                    this.outStream.println("          For more information visit:");
                    this.outStream.println("          http://sonoair.mihosoft.eu/codec-not-supported.html");
                    this.dividerProperty.set(0.0);
                    continue;
                }
                this.outStream.println(line);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SonoAir.class.getName()).log(Level.SEVERE, null, ex);
            this.outStream.println(" [failed]");
            this.dividerProperty.set(0.0);
            this.stopAirSonnos();
        }
    }

    private void addDeviceNotification(String devName) {
        System.out.println("Adding device " + devName);
        Platform.runLater(() -> {
            this.deviceView.getItems().add((Object)devName);
            this.primaryStage.setTitle("SonoAir v1.0 (BETA 3.1)");
        });
    }

    private void scanDevies() {
        Platform.runLater(() -> this.primaryStage.setTitle("SonoAir v1.0 (BETA 3.1) (searching devices...)"));
    }

    public static void main(String[] args) {
        SonoAir.launch((String[])args);
    }

    private void stopAirSonnos() {
        Platform.runLater(() -> {
            this.windowTitleProperty.set((Object)"SonoAir v1.0 (BETA 3.1)");
            this.deviceView.getItems().clear();
            this.btnTextProperty.set((Object)"Start SonoAir");
        });
        if (this.process != null) {
            try {
                this.process.destroy();
            }
            finally {
                this.process = null;
                this.outStream.println("--------------------------------------------------------------");
                this.outStream.println("-> airsonos module stopped.");
            }
        }
    }
}

