/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class VClassLoaderUtil {
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();
    private static final Map<String, Class<?>> primitiveWrapperClasses = new HashMap();
    private static final Map<String, Class<?>> primitiveSignatures = new HashMap();
    private static final Map<String, String> primitiveSignaturesToFullNames = new HashMap<String, String>();

    public static Class<?> forName(String clsName, ClassLoader classLoader) throws ClassNotFoundException {
        if (clsName.startsWith("[")) {
            int arrayDim = VClassLoaderUtil.arrayDimension(clsName);
            String elementClsName = clsName.substring(arrayDim, clsName.length());
            Class<?> elementClass = null;
            if (elementClsName.endsWith(";")) {
                elementClsName = elementClsName.substring(1, elementClsName.length() - 1);
                elementClass = classLoader.loadClass(elementClsName);
            } else {
                elementClass = VClassLoaderUtil.primitiveClassForName(elementClsName);
            }
            Class<?> result = Array.newInstance(elementClass, new int[arrayDim]).getClass();
            return result;
        }
        return classLoader.loadClass(clsName);
    }

    public static int arrayDimension(String clsName) {
        int arrayDim = 0;
        if (clsName.startsWith("[")) {
            for (int i = 0; i < clsName.length() && clsName.charAt(i) == '['; ++i) {
                arrayDim = i + 1;
            }
        }
        return arrayDim;
    }

    public static String arrayClass2Code(String clsName) {
        String elementClassName;
        int arrayDimension = VClassLoaderUtil.arrayDimension(clsName);
        String result = elementClassName = VClassLoaderUtil.elementClassName(clsName);
        for (int i = 0; i < arrayDimension; ++i) {
            result = result + "[]";
        }
        return result;
    }

    public static String elementClassName(String clsName) {
        int arrayDimension = VClassLoaderUtil.arrayDimension(clsName);
        if (arrayDimension == 0) {
            return clsName;
        }
        String elementClsName = clsName.substring(arrayDimension, clsName.length());
        elementClsName = elementClsName.endsWith(";") ? elementClsName.substring(1, elementClsName.length() - 1) : primitiveSignaturesToFullNames.get(elementClsName);
        return elementClsName;
    }

    public static Class<?> convertPrimitiveToWrapper(Class<?> clazz) {
        Class<?> result = clazz;
        if (clazz.isPrimitive()) {
            return primitiveWrapperClasses.get(clazz.getName());
        }
        return result;
    }

    private static Class<?> primitiveClassForName(String name) {
        Class<?> result = primitiveClasses.get(name);
        if (result == null) {
            result = primitiveSignatures.get(name);
        }
        if (result == null) {
            throw new IllegalArgumentException("Given name does not specifiy a primitive type.");
        }
        return result;
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        primitiveWrapperClasses.put("boolean", Boolean.class);
        primitiveWrapperClasses.put("byte", Byte.class);
        primitiveWrapperClasses.put("short", Short.class);
        primitiveWrapperClasses.put("char", Character.class);
        primitiveWrapperClasses.put("int", Integer.class);
        primitiveWrapperClasses.put("long", Long.class);
        primitiveWrapperClasses.put("float", Float.class);
        primitiveWrapperClasses.put("double", Double.class);
        primitiveWrapperClasses.put("void", Void.TYPE);
        primitiveSignatures.put("Z", Boolean.TYPE);
        primitiveSignatures.put("B", Byte.TYPE);
        primitiveSignatures.put("C", Character.TYPE);
        primitiveSignatures.put("D", Double.TYPE);
        primitiveSignatures.put("F", Float.TYPE);
        primitiveSignatures.put("I", Integer.TYPE);
        primitiveSignatures.put("J", Long.TYPE);
        primitiveSignatures.put("S", Short.TYPE);
        primitiveSignatures.put("V", Void.TYPE);
        primitiveSignaturesToFullNames.put("Z", "boolean");
        primitiveSignaturesToFullNames.put("B", "byte");
        primitiveSignaturesToFullNames.put("C", "char");
        primitiveSignaturesToFullNames.put("D", "double");
        primitiveSignaturesToFullNames.put("F", "float");
        primitiveSignaturesToFullNames.put("I", "int");
        primitiveSignaturesToFullNames.put("J", "long");
        primitiveSignaturesToFullNames.put("S", "short");
        primitiveSignaturesToFullNames.put("V", "void");
    }
}

