/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.ClassValidator;
import eu.mihosoft.vrl.base.ExistingFileValidator;
import eu.mihosoft.vrl.base.ExistingFolderValidator;
import eu.mihosoft.vrl.base.FileValidator;
import eu.mihosoft.vrl.base.InstanceOfValidator;
import eu.mihosoft.vrl.base.NotNullValidator;
import eu.mihosoft.vrl.base.ParameterValidator;
import eu.mihosoft.vrl.base.ValidationResult;
import java.util.Collection;

public class VParamUtil {
    public static final ParameterValidator VALIDATOR_NOT_NULL = new NotNullValidator();
    public static final ParameterValidator VALIDATOR_FILE = new FileValidator();
    public static final ParameterValidator VALIDATOR_EXISTING_FILE = new ExistingFileValidator();
    public static final ParameterValidator VALIDATOR_EXISTING_FOLDER = new ExistingFolderValidator();
    public static final ParameterValidator VALIDATOR_CLASS = new ClassValidator();
    public static final ParameterValidator VALIDATOR_INSTANCEOF = new InstanceOfValidator();

    public static void throwIfNull(Object ... params) {
        VParamUtil.throwIfNotValid(VALIDATOR_NOT_NULL, null, params);
    }

    public static void throwIfNotValid(ParameterValidator v, Object validationArg, Object ... params) {
        for (Object o : params) {
            ValidationResult r = v.validate(o, validationArg);
            if (r.isValid()) continue;
            throw new IllegalArgumentException(r.getMessage());
        }
    }

    public static ValidationResult validate(ParameterValidator v, Object validationArg, Object ... params) {
        for (Object o : params) {
            ValidationResult r = v.validate(o, validationArg);
            if (r.isValid()) continue;
            return r;
        }
        return ValidationResult.VALID;
    }

    public static ValidationResult validate(ParameterValidator v, Object validationArg, Collection<?> params) {
        for (Object o : params) {
            ValidationResult r = v.validate(o, validationArg);
            if (r.isValid()) continue;
            return r;
        }
        return ValidationResult.VALID;
    }

    public static ValidationResult validate(ParameterValidator v, Collection<?> params) {
        return VParamUtil.validate(v, null, params);
    }

    public static void throwIfNotValid(ParameterValidator v, Object validationArg, Collection<?> params) {
        for (Object o : params) {
            ValidationResult r = v.validate(o, validationArg);
            if (r.isValid()) continue;
            throw new IllegalArgumentException(r.getMessage());
        }
    }

    public static void throwIfNotValid(ParameterValidator v, Collection<?> params) {
        VParamUtil.throwIfNotValid(v, null, params);
    }
}

