/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.vrl.base;

import eu.mihosoft.vrl.base.Constants;
import eu.mihosoft.vrl.base.IOUtil;
import eu.mihosoft.vrl.base.SynchronizedFileAccess;
import eu.mihosoft.vrl.base.VSysUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VPropertyFolderManager {
    private final String HOME_FOLDER = System.getProperty("user.home");
    private final File PROPERTY_FOLDER_BASE;
    private File PROPERTY_FOLDER;
    private File PROPERTY_FOLDER_TEMPLATE;
    private File TMP_BASE;
    private File PLUGIN_UPDATES;
    private File CONFIG_FOLDER;
    private File UPDATES;
    private File ETC;
    private File TMP;
    private File RESOURCES;
    private File PROJECT_TEMPLATES;
    private int maximumNumberOfBackups = 5;
    private boolean initialized = false;
    private Runnable alreadyRunningTask;

    public VPropertyFolderManager() {
        this.PROPERTY_FOLDER_BASE = VPropertyFolderManager.generatePropertyBasePath(Paths.get(this.HOME_FOLDER, new String[0]));
    }

    public VPropertyFolderManager(Path baseLocation) {
        this.PROPERTY_FOLDER_BASE = VPropertyFolderManager.generatePropertyBasePath(baseLocation);
    }

    private static File generatePropertyBasePath(Path baseLocation) {
        return new File(baseLocation.toFile() + "/.vrl/" + Constants.VERSION_INFO.getVersion() + "/default");
    }

    public void setAlreadyRunningTask(Runnable r) {
        this.alreadyRunningTask = r;
    }

    public void installBundledSoftwareAndResources() throws IOException {
        IOUtil.copyDirectory(this.PROPERTY_FOLDER_TEMPLATE, this.getPropertyFolder());
    }

    public void create() throws IOException {
        if (this.PROPERTY_FOLDER.exists() && !this.getPropertyFolder().isDirectory()) {
            throw new IOException("VRL property folder cannot be created: " + this.getPropertyFolder().getAbsolutePath() + " A file with this" + " name already exists.");
        }
        if (this.PROPERTY_FOLDER_TEMPLATE != null && !this.getPropertyFolder().exists()) {
            System.out.println(" --> initializing property folder from template");
            if (this.PROPERTY_FOLDER_TEMPLATE.isDirectory()) {
                IOUtil.copyDirectory(this.PROPERTY_FOLDER_TEMPLATE, this.getPropertyFolder());
            } else {
                System.out.println("  --> requested template does not exist! Using empty folder.");
            }
        }
        if (!this.getPropertyFolder().exists() && !this.getPropertyFolder().mkdirs()) {
            throw new IOException("VRL property folder cannot be created: " + this.getPropertyFolder().getAbsolutePath());
        }
        this.CONFIG_FOLDER.mkdirs();
        this.PLUGIN_UPDATES.mkdir();
        this.UPDATES.mkdir();
        this.TMP_BASE.mkdir();
        this.ETC.mkdir();
        this.RESOURCES.mkdir();
        this.PROJECT_TEMPLATES.mkdir();
    }

    public void remove() throws IOException {
        System.out.println(">> removing preference folder");
        if (VSysUtil.isWindows()) {
            IOUtil.deleteTmpFilesOnExitIgnoreFileLocks(this.getPropertyFolder());
        } else {
            IOUtil.deleteDirectory(this.getPropertyFolder());
        }
    }

    public void init() {
        this.init(null, false);
    }

    public void init(String folder, boolean asSuffix) {
        if (!this.isInitialized()) {
            if (asSuffix) {
                if (folder == null) {
                    this.setPropertyFolder(new File(this.PROPERTY_FOLDER_BASE, "default"));
                } else {
                    this.setPropertyFolder(new File(this.PROPERTY_FOLDER_BASE, folder));
                }
            } else if (folder == null) {
                this.setPropertyFolder(new File(this.PROPERTY_FOLDER_BASE, "default"));
            } else {
                this.setPropertyFolder(new File(folder));
            }
            System.out.println(" --> initializing property folder: " + this.getPropertyFolder());
            this.TMP_BASE = new File(this.getPropertyFolder(), "tmp");
            this.TMP = new File(this.TMP_BASE, "0");
            this.CONFIG_FOLDER = new File(this.getPropertyFolder(), "config");
            this.PLUGIN_UPDATES = new File(this.getPropertyFolder(), "plugin-updates");
            this.UPDATES = new File(this.getPropertyFolder(), "updates");
            this.ETC = new File(this.getPropertyFolder(), "etc");
            this.RESOURCES = new File(this.getPropertyFolder(), "resources");
            this.PROJECT_TEMPLATES = new File(this.RESOURCES, "project-templates");
            this.lockFolder(true);
            try {
                this.create();
            }
            catch (IOException ex) {
                Logger.getLogger(VPropertyFolderManager.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            throw new IllegalStateException("Already initialized.");
        }
        this.shiftTmpFolders();
        this.initialized = true;
    }

    private void shiftTmpFolders() {
        for (File f : this.TMP_BASE.listFiles()) {
            if (!f.getName().matches("\\d+")) {
                IOUtil.deleteDirectory(f);
                continue;
            }
            int value = new Integer(f.getName());
            if (value <= this.maximumNumberOfBackups) continue;
            IOUtil.deleteDirectory(f);
        }
        IOUtil.deleteDirectory(new File(this.TMP_BASE, "" + this.maximumNumberOfBackups));
        for (int i = this.maximumNumberOfBackups - 1; i >= 0; --i) {
            new File(this.TMP_BASE, "" + i).renameTo(new File(this.TMP_BASE, "" + (i + 1)));
        }
        this.TMP.mkdir();
    }

    public File getTmpFolder() {
        return this.TMP;
    }

    public File getConfigFolder() {
        return this.CONFIG_FOLDER;
    }

    public File getPluginUpdatesFolder() {
        return this.PLUGIN_UPDATES;
    }

    public File getUpdatesFolder() {
        return this.UPDATES;
    }

    public File getResourcesFolder() {
        return this.RESOURCES;
    }

    public File getProjectTemplatesFolder() {
        return this.PROJECT_TEMPLATES;
    }

    public File getPropertyFolder() {
        return this.PROPERTY_FOLDER;
    }

    public void setPropertyFolder(File propertyFolder) {
        this.PROPERTY_FOLDER = propertyFolder;
    }

    public File getPropertyFolderTemplate() {
        return this.PROPERTY_FOLDER_TEMPLATE;
    }

    public File getEtcFolder() {
        return this.ETC;
    }

    public File toLocalPathInTmpFolder(File f) {
        File result = new File(this.getTmpFolder(), this.toLocalPath(f).getPath());
        return result;
    }

    public File toLocalPath(File f) {
        String path = f.getAbsolutePath();
        if (VSysUtil.isWindows()) {
            for (File drive : File.listRoots()) {
                String s = drive.getAbsolutePath();
                if (!path.startsWith(s)) continue;
                path = "Drive_" + s.substring(0, 1) + "\\" + path.substring(2);
            }
        } else if ((VSysUtil.isLinux() || VSysUtil.isMacOSX()) && path.startsWith("/")) {
            path = path.substring(1);
        }
        return new File(path);
    }

    public void evalueteArgs(String[] args) {
        String template = null;
        String folder = null;
        String subfolder = "default";
        System.out.println(">> Property Folder Options:");
        if (template != null) {
            System.out.println(" --> using property folder template, path: " + template);
            this.PROPERTY_FOLDER_TEMPLATE = new File(template);
        }
        boolean ignoreSuffix = false;
        if (folder != null && subfolder != null) {
            System.out.println("folder: " + folder + ", subfolder: " + subfolder);
            System.out.println(" --> cannot define both, custom folder and suffix. Ignoring suffix!");
            ignoreSuffix = true;
        }
        if (folder != null) {
            System.out.println(" --> using custom property folder, path: " + folder);
            this.init(folder, false);
            return;
        }
        if (!ignoreSuffix && subfolder != null) {
            System.out.println(" --> using custom property folder suffix, suffix: " + subfolder);
            this.init(subfolder, true);
            return;
        }
        System.out.println(" --> no folder or suffix specified, using default.");
        this.init();
    }

    public void lockFolder(boolean force) {
        File lockFile = new File(this.getPropertyFolder(), ".lock");
        try {
            lockFile.createNewFile();
        }
        catch (IOException ex) {
            System.out.println(" --> cannot lock property folder (does not exist).");
        }
        SynchronizedFileAccess.lockFile(lockFile);
    }

    public boolean isLocked() {
        File lockFile = new File(this.getPropertyFolder(), ".lock");
        return SynchronizedFileAccess.isLocked(lockFile);
    }

    public void unlockFolder() {
        System.out.println(" --> unlocking property folder (action will be performed on shutdown).");
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

