/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.TaskProgressViewSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class TaskProgressView<T extends Task<?>>
extends Control {
    private final ObservableList<T> tasks = FXCollections.observableArrayList();
    private ObjectProperty<Callback<T, Node>> graphicFactory;

    public TaskProgressView() {
        this.getStyleClass().add((Object)"task-progress-view");
        final EventHandler taskHandler = evt -> {
            if (evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_SUCCEEDED) || evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_CANCELLED) || evt.getEventType().equals(WorkerStateEvent.WORKER_STATE_FAILED)) {
                this.getTasks().remove((Object)evt.getSource());
            }
        };
        this.getTasks().addListener(new ListChangeListener<Task<?>>(){

            public void onChanged(ListChangeListener.Change<? extends Task<?>> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        for (Task task : c.getAddedSubList()) {
                            task.addEventHandler(WorkerStateEvent.ANY, taskHandler);
                        }
                        continue;
                    }
                    if (!c.wasRemoved()) continue;
                    for (Task task : c.getAddedSubList()) {
                        task.removeEventHandler(WorkerStateEvent.ANY, taskHandler);
                    }
                }
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new TaskProgressViewSkin(this);
    }

    public final ObservableList<T> getTasks() {
        return this.tasks;
    }

    public final ObjectProperty<Callback<T, Node>> graphicFactoryProperty() {
        if (this.graphicFactory == null) {
            this.graphicFactory = new SimpleObjectProperty((Object)this, "graphicFactory");
        }
        return this.graphicFactory;
    }

    public final Callback<T, Node> getGraphicFactory() {
        return this.graphicFactory == null ? null : (Callback)this.graphicFactory.get();
    }

    public final void setGraphicFactory(Callback<T, Node> factory) {
        this.graphicFactoryProperty().set(factory);
    }
}

