/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.IStandardCommand;
import org.tensin.sonos.commands.IZoneCommandDispatcher;
import org.tensin.sonos.commands.ZoneCommandDispatcher;
import org.tensin.sonos.commands.ZoneCommandExecutor;
import org.tensin.sonos.helpers.TimeUtilities;

public class CommandDiscover
implements IStandardCommand {
    private final IZoneCommandDispatcher zoneCommandDispatcher = ZoneCommandDispatcher.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandDiscover.class);

    @Override
    public void execute() throws SonosException {
        TimeUtilities.waitMilliSeconds(2500L);
        Map<String, ZoneCommandExecutor> executors = this.zoneCommandDispatcher.getExecutors();
        int count = executors.size();
        for (Map.Entry<String, ZoneCommandExecutor> entry : executors.entrySet()) {
            LOGGER.info(" - Zone [" + entry.getKey() + "]");
        }
        LOGGER.info(count + " Sonos zones found on Network in " + 2500 + "ms.");
    }

    @Override
    public String getDescription() {
        return "Discover every Sonos box on the network";
    }

    @Override
    public String getName() {
        return "discover";
    }

    @Override
    public boolean needArgs() {
        return false;
    }
}

