/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.CommandAdd;
import org.tensin.sonos.commands.CommandBrowse;
import org.tensin.sonos.commands.CommandDiscover;
import org.tensin.sonos.commands.CommandGetArtists;
import org.tensin.sonos.commands.CommandGetInfo;
import org.tensin.sonos.commands.CommandMove;
import org.tensin.sonos.commands.CommandMuteOff;
import org.tensin.sonos.commands.CommandMuteOn;
import org.tensin.sonos.commands.CommandNext;
import org.tensin.sonos.commands.CommandPause;
import org.tensin.sonos.commands.CommandPlay;
import org.tensin.sonos.commands.CommandPrev;
import org.tensin.sonos.commands.CommandRemove;
import org.tensin.sonos.commands.CommandRemoveAll;
import org.tensin.sonos.commands.CommandSave;
import org.tensin.sonos.commands.CommandShuffleOff;
import org.tensin.sonos.commands.CommandShuffleOn;
import org.tensin.sonos.commands.CommandStop;
import org.tensin.sonos.commands.CommandTrack;
import org.tensin.sonos.commands.CommandVolume;
import org.tensin.sonos.commands.CommandVolumeDown;
import org.tensin.sonos.commands.CommandVolumeUp;
import org.tensin.sonos.commands.ICommand;

public class CommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandFactory.class);
    private static Collection<ICommand> foundCommands;

    public static ICommand createCommand(String commandName) {
        Collection<ICommand> availableCommands = CommandFactory.getAvailableCommands(ICommand.class);
        for (ICommand command : availableCommands) {
            if (!command.getName().equalsIgnoreCase(commandName)) continue;
            return command;
        }
        return null;
    }

    public static Collection<? extends ICommand> createCommandStack(Collection<String> commands, Class<? extends ICommand> clazz) throws SonosException {
        ArrayList<ICommand> commandStack = new ArrayList<ICommand>();
        Iterator<String> itr = commands.iterator();
        while (itr.hasNext()) {
            String s = itr.next();
            ICommand foundCommand = CommandFactory.createCommand(s);
            if (foundCommand == null || !clazz.isAssignableFrom(foundCommand.getClass())) continue;
            commandStack.add(foundCommand);
            itr.remove();
        }
        return commandStack;
    }

    public static Collection<ICommand> getAvailableCommands(Class<ICommand> clazz) {
        if (foundCommands == null) {
            foundCommands = new ArrayList<ICommand>();
            foundCommands.add(new CommandAdd());
            foundCommands.add(new CommandDiscover());
            foundCommands.add(new CommandGetInfo());
            foundCommands.add(new CommandGetArtists());
            foundCommands.add(new CommandBrowse());
            foundCommands.add(new CommandMove());
            foundCommands.add(new CommandMuteOff());
            foundCommands.add(new CommandMuteOn());
            foundCommands.add(new CommandNext());
            foundCommands.add(new CommandPause());
            foundCommands.add(new CommandPlay());
            foundCommands.add(new CommandPrev());
            foundCommands.add(new CommandRemove());
            foundCommands.add(new CommandRemoveAll());
            foundCommands.add(new CommandSave());
            foundCommands.add(new CommandShuffleOff());
            foundCommands.add(new CommandShuffleOn());
            foundCommands.add(new CommandStop());
            foundCommands.add(new CommandTrack());
            foundCommands.add(new CommandVolume());
            foundCommands.add(new CommandVolumeDown());
            foundCommands.add(new CommandVolumeUp());
        }
        return foundCommands;
    }
}

