/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import org.fourthline.cling.UpnpService;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.action.ActionArgumentValue;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.UDAServiceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.control.UpnpMessageFactory;

public abstract class AbstractService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);
    protected static final int DEFAULT_EVENT_PERIOD = 3600;
    protected final Service service;
    protected UpnpService upnpService = null;
    protected final UpnpMessageFactory messageFactory;

    public static Service findService(RemoteDevice device, String serviceName) {
        UDAServiceId uadServiceId = UDAServiceId.valueOf((String)serviceName.replace(":1", ""));
        return device.findService((ServiceId)uadServiceId);
    }

    public AbstractService(UpnpService upnpService, Service service, String type) {
        if (service != null && !service.getServiceType().toString().equals(type)) {
            throw new IllegalArgumentException("service must be " + type + ", not " + service.getServiceType());
        }
        this.upnpService = upnpService;
        this.service = service;
        this.messageFactory = UpnpMessageFactory.getNewInstance();
    }

    public void dispose() {
    }

    protected void execute(ActionInvocation message) {
        ActionCallback callback = new ActionCallback(message){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.error(defaultMsg);
            }

            public void success(ActionInvocation invocation) {
                ActionArgumentValue[] output = invocation.getOutput();
            }
        };
        this.getUpnpService().getControlPoint().execute(callback);
    }

    protected void executeImmediate(ActionInvocation message) {
        new ActionCallback.Default(message, this.getUpnpService().getControlPoint()).run();
    }

    public Service getService() {
        return this.service;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }
}

