/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import java.util.List;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.BrowseHandle;
import org.tensin.sonos.control.EntryCallback;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.xml.ResultParser;
import org.xml.sax.SAXException;

public class ContentDirectoryService
extends AbstractService {
    public static final int DEFAULT_REQUEST_COUNT = 1024;
    public static final String DEFAULT_SORT_CRITERIA = "";
    public static final String DEFAULT_FILTER_STRING = "dc:title,res,dc:creator,upnp:artist,upnp:album";
    public static final BrowseType DEFAULT_BROWSE_TYPE = BrowseType.BrowseDirectChildren;
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentDirectoryService.class);

    protected ContentDirectoryService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:ContentDirectory:1");
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public List<Entry> getAlbums(int startAt, int length) throws SonosException {
        return this.getEntries(startAt, length, "A:ALBUM");
    }

    public BrowseHandle getAllEntriesAsync(EntryCallback callback, String type) {
        AsyncBrowser handle = new AsyncBrowser(type, callback);
        new Thread(handle).start();
        return handle;
    }

    public List<Entry> getArtists(int startAt, int length) throws SonosException {
        return this.getEntries(startAt, length, "A:ARTIST");
    }

    public List<Entry> getEntries(int startAt, int length, String type) throws SonosException {
        return this.getEntries(startAt, length, type, DEFAULT_BROWSE_TYPE);
    }

    public List<Entry> getEntries(int startAt, int length, String type, BrowseType browseType) throws SonosException {
        return this.getEntries(startAt, length, type, browseType, DEFAULT_FILTER_STRING, DEFAULT_SORT_CRITERIA);
    }

    public List<Entry> getEntries(int startAt, int length, String type, BrowseType browseType, String filterString, String sortCriteria) throws SonosException {
        try {
            SonosActionInvocation response = this.getEntriesImpl(startAt, length, type, browseType, filterString, sortCriteria);
            LOGGER.info("Returned " + response.getOutputAsString("NumberReturned") + " of " + response.getOutputAsString("TotalMatches") + " results.");
            String result = response.getOutputAsString("Result");
            LOGGER.debug(result);
            return ResultParser.getEntriesFromStringResult(result);
        }
        catch (SAXException e) {
            throw new SonosException(e);
        }
    }

    protected SonosActionInvocation getEntriesImpl(int startAt, int length, String type, BrowseType browseType, String filter, String sortCriteria) {
        SonosActionInvocation browseAction = this.messageFactory.getMessage(this.getService(), "Browse");
        browseAction.setInput("ObjectID", type);
        browseAction.setInput("BrowseFlag", String.valueOf((Object)browseType));
        browseAction.setInput("Filter", filter);
        browseAction.setInput("StartingIndex", String.valueOf(startAt));
        browseAction.setInput("RequestedCount", String.valueOf(length));
        browseAction.setInput("SortCriteria", sortCriteria);
        this.executeImmediate(browseAction);
        return browseAction;
    }

    public List<Entry> getFolderEntries(int startAt, int length) throws SonosException {
        return this.getEntries(startAt, length, "A:");
    }

    public List<Entry> getQueue(int startAt, int length) throws SonosException {
        return this.getEntries(startAt, length, "Q:0");
    }

    public String getSearchCapabilites() {
        SonosActionInvocation browseAction = this.messageFactory.getMessage(this.getService(), "GetSortCapabilities");
        this.executeImmediate(browseAction);
        return browseAction.getOutputAsString("SortCaps");
    }

    public Entry getSingleEntry(String type) throws SonosException {
        try {
            SonosActionInvocation response = this.getEntriesImpl(0, 1, type, BrowseType.BrowseMetadata, DEFAULT_FILTER_STRING, DEFAULT_SORT_CRITERIA);
            LOGGER.info("Returned " + response.getOutputAsString("NumberReturned") + " of " + response.getOutputAsString("TotalMatches") + " results.");
            String result = response.getOutputAsString("Result");
            LOGGER.debug(result);
            List<Entry> entries = ResultParser.getEntriesFromStringResult(result);
            if (entries.size() > 0) {
                return entries.get(0);
            }
            return null;
        }
        catch (SAXException e) {
            throw new SonosException(e);
        }
    }

    public List<Entry> getTracks(int startAt, int length) throws SonosException {
        return this.getEntries(startAt, length, "A:TRACKS");
    }

    public static enum BrowseType {
        BrowseDirectChildren,
        BrowseMetadata;

    }

    private final class AsyncBrowser
    implements Runnable,
    BrowseHandle {
        private final String type;
        private final EntryCallback callback;
        private boolean isCancelled = false;

        protected AsyncBrowser(String type, EntryCallback callback) {
            this.type = type;
            this.callback = callback;
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int startAt = 0;
            boolean completedSuccessfully = false;
            try {
                SonosActionInvocation response = ContentDirectoryService.this.getEntriesImpl(startAt, 1024, this.type, DEFAULT_BROWSE_TYPE, ContentDirectoryService.DEFAULT_FILTER_STRING, ContentDirectoryService.DEFAULT_SORT_CRITERIA);
                int totalCount = response.getOutputAsInteger("TotalMatches");
                startAt = response.getOutputAsInteger("NumberReturned");
                this.callback.updateCount(this, totalCount);
                if (!this.isCancelled) {
                    this.callback.addEntries(this, ResultParser.getEntriesFromStringResult(response.getOutputAsString("Result")));
                }
                while (!this.isCancelled && startAt < totalCount) {
                    response = ContentDirectoryService.this.getEntriesImpl(startAt, 1024, this.type, DEFAULT_BROWSE_TYPE, ContentDirectoryService.DEFAULT_FILTER_STRING, ContentDirectoryService.DEFAULT_SORT_CRITERIA);
                    startAt += Integer.parseInt(response.getOutputAsString("NumberReturned"));
                    if (this.isCancelled) continue;
                    this.callback.addEntries(this, ResultParser.getEntriesFromStringResult(response.getOutputAsString("Result")));
                }
                completedSuccessfully = !this.isCancelled;
            }
            catch (SAXException e) {
                LOGGER.error("Error while getting content directory", (Throwable)e);
            }
            finally {
                this.callback.retrievalComplete(this, completedSuccessfully);
            }
        }
    }
}

