/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.helpers;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public final class SLF4JHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SLF4JHelper.class);

    public static void changeLoggerLevel(String module, Level level) {
        ch.qos.logback.classic.Logger logbackLogger;
        String moduleRenamed = module.replaceAll("/", ".");
        if (LOGGER instanceof ch.qos.logback.classic.Logger && (logbackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)moduleRenamed)) != null) {
            logbackLogger.setLevel(level);
        }
    }

    public static void configureJULLogging() {
        LOGGER.info("Installing JULToSlf4J bridge (for redirectering Jersey logs)");
        if (LOGGER instanceof ch.qos.logback.classic.Logger) {
            LevelChangePropagator listener = new LevelChangePropagator();
            LoggerContext loggerContext = ((ch.qos.logback.classic.Logger)LOGGER).getLoggerContext();
            loggerContext.addListener((LoggerContextListener)listener);
            listener.setContext((Context)loggerContext);
            loggerContext.start();
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
    }

    private SLF4JHelper() {
    }
}

