/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.helpers;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class TimeUtilities {
    private static final PeriodFormatter periodFormatter;

    public static long convertDurationToLong(String duration) {
        if ("NOT_IMPLEMENTED".equals(duration) || "".equals(duration) || duration == null) {
            return -1L;
        }
        Period period = periodFormatter.parsePeriod(duration);
        return period.toDurationFrom((ReadableInstant)new Instant()).getMillis();
    }

    public static long convertISO8601DateToLong(String date) {
        return new DateTime((Object)date).getMillis();
    }

    public static long convertISO8601DurationToLong(String duration) {
        return new Duration((Object)duration).getMillis();
    }

    public static String convertLongToDuration(long duration) {
        Period period = new Period(duration);
        return periodFormatter.print((ReadablePeriod)period);
    }

    public static String convertLongToISO8601Date(long date) {
        return new DateTime(date).toString();
    }

    public static String convertLongToISO8601Duration(long duration) {
        return new Duration(duration).toString();
    }

    public static void waitMilliSeconds(long waitTimeInMilliseconds) {
        try {
            Thread.sleep(waitTimeInMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitSeconds(long waitTimeInSeconds) {
        TimeUtilities.waitMilliSeconds(waitTimeInSeconds * 1000L);
    }

    static {
        PeriodFormatterBuilder builder = new PeriodFormatterBuilder();
        periodFormatter = builder.printZeroAlways().appendHours().minimumPrintedDigits(2).maximumParsedDigits(2).appendSeparator(":").minimumPrintedDigits(2).appendMinutes().appendSeparator(":").appendSecondsWithOptionalMillis().toFormatter();
    }
}

