/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.control.ZonePlayer;

public class TrackMetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackMetaData.class);
    private final String id;
    private final String parentId;
    private final String resource;
    private final String streamContent;
    private final String albumArtUri;
    private final String title;
    private final String upnpClass;
    private final String creator;
    private final String album;
    private final String albumArtist;

    public TrackMetaData(String id, String parentId, String res, String streamContent, String albumArtUri, String title, String upnpClass, String creator, String album, String albumArtist) {
        this.id = id;
        this.parentId = parentId;
        this.resource = res;
        this.streamContent = streamContent;
        this.albumArtUri = albumArtUri;
        this.title = title;
        this.upnpClass = upnpClass;
        this.creator = creator;
        this.album = album;
        this.albumArtist = albumArtist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAlbumArtist() {
        return this.albumArtist;
    }

    public String getAlbumArtUri() {
        return this.albumArtUri;
    }

    public URL getAlbumArtUrl(ZonePlayer zp) throws MalformedURLException {
        String uri = this.getAlbumArtUri();
        if (uri.startsWith("/getAA")) {
            LOGGER.info("uri = " + uri);
        }
        return uri.length() == 0 ? null : new URL("http", zp.getIP().getHostAddress(), zp.getPort(), uri);
    }

    public String getCreator() {
        return this.creator;
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getResource() {
        return this.resource;
    }

    public String getStreamContent() {
        return this.streamContent;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUpnpClass() {
        return this.upnpClass;
    }
}

