/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.xml;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.model.Entry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EntryHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryHandler.class);
    private static List<String> ignore = null;
    private String id;
    private String parentId;
    private StringBuilder upnpClass = new StringBuilder();
    private StringBuilder res = new StringBuilder();
    private StringBuilder title = new StringBuilder();
    private StringBuilder album = new StringBuilder();
    private StringBuilder albumArtist = new StringBuilder();
    private StringBuilder albumArtUri = new StringBuilder();
    private StringBuilder creator = new StringBuilder();
    private StringBuilder trackNumber = new StringBuilder();
    private Element element = null;
    private final List<Entry> artists = new ArrayList<Entry>();

    EntryHandler() {
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.element == null) {
            return;
        }
        switch (this.element) {
            case TITLE: {
                this.title.append(ch, start, length);
                break;
            }
            case CLASS: {
                this.upnpClass.append(ch, start, length);
                break;
            }
            case RES: {
                this.res.append(ch, start, length);
                break;
            }
            case ALBUM: {
                this.album.append(ch, start, length);
                break;
            }
            case ALBUM_ARTIST: {
                this.albumArtist.append(ch, start, length);
                break;
            }
            case ALBUM_ART_URI: {
                this.albumArtUri.append(ch, start, length);
                break;
            }
            case CREATOR: {
                this.creator.append(ch, start, length);
                break;
            }
            case TRACK_NUMBER: {
                this.trackNumber.append(ch, start, length);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("container") || qName.equals("item")) {
            this.element = null;
            int trackNumberVal = 0;
            try {
                trackNumberVal = Integer.parseInt(this.trackNumber.toString());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.artists.add(new Entry(this.id, this.title.toString(), this.parentId, this.album.toString(), this.albumArtUri.toString(), this.creator.toString(), this.upnpClass.toString(), this.res.toString(), trackNumberVal, this.albumArtist.toString()));
            this.title = new StringBuilder();
            this.upnpClass = new StringBuilder();
            this.res = new StringBuilder();
            this.album = new StringBuilder();
            this.albumArtUri = new StringBuilder();
            this.creator = new StringBuilder();
            this.trackNumber = new StringBuilder();
            this.albumArtist = new StringBuilder();
        }
    }

    public List<Entry> getArtists() {
        return this.artists;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("container") || qName.equals("item")) {
            this.id = attributes.getValue("id");
            this.parentId = attributes.getValue("parentID");
        } else if (qName.equals("res")) {
            this.element = Element.RES;
        } else if (qName.equals("dc:title")) {
            this.element = Element.TITLE;
        } else if (qName.equals("upnp:class")) {
            this.element = Element.CLASS;
        } else if (qName.equals("dc:creator")) {
            this.element = Element.CREATOR;
        } else if (qName.equals("upnp:album")) {
            this.element = Element.ALBUM;
        } else if (qName.equals("r:albumArtist")) {
            this.element = Element.ALBUM_ARTIST;
        } else if (qName.equals("upnp:albumArtURI")) {
            this.element = Element.ALBUM_ART_URI;
        } else if (qName.equals("upnp:originalTrackNumber")) {
            this.element = Element.TRACK_NUMBER;
        } else {
            if (ignore == null) {
                ignore = new ArrayList<String>();
                ignore.add("DIDL-Lite");
            }
            if (!ignore.contains(localName)) {
                LOGGER.warn("did not recognise element named [" + localName + "], qname [" + qName + "]");
            }
            this.element = null;
        }
    }

    private static enum Element {
        TITLE,
        CLASS,
        ALBUM,
        ALBUM_ARTIST,
        ALBUM_ART_URI,
        CREATOR,
        RES,
        TRACK_NUMBER;

    }
}

