/*
 * Decompiled with CFR 0.152.
 */
package nl.revolution.sonos.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.revolution.sonos.api.ZonePlayer;
import nl.revolution.sonos.api.internal.Utils;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.model.message.header.UDAServiceTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.registry.DefaultRegistryListener;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZonePlayers {
    private static final Logger LOG = LoggerFactory.getLogger(ZonePlayers.class);
    private List<ZonePlayer> zones = Collections.synchronizedList(new ArrayList());

    public static ZonePlayers discover() {
        final ZonePlayers zonePlayers = new ZonePlayers();
        UpnpServiceImpl lookupService = new UpnpServiceImpl();
        UpnpServiceImpl upnpService = new UpnpServiceImpl(new RegistryListener[]{new DefaultRegistryListener((UpnpService)lookupService){
            final /* synthetic */ UpnpService val$lookupService;
            {
                this.val$lookupService = upnpService;
            }

            public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
                if (zonePlayers.isSonos(device)) {
                    zonePlayers.add(new ZonePlayer(device, this.val$lookupService));
                }
            }
        }});
        upnpService.getControlPoint().search((UpnpHeader)new UDAServiceTypeHeader(new UDAServiceType("AVTransport")), 120);
        return zonePlayers;
    }

    public ZonePlayer get(String zoneName, int timeout) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)timeout) {
            for (ZonePlayer zone : this.zones) {
                if (!zone.getZoneName().equalsIgnoreCase(zoneName)) continue;
                return zone;
            }
            Utils.sleep(100);
        }
        LOG.info("returning null");
        return null;
    }

    private void add(ZonePlayer zone) {
        this.zones.add(zone);
    }

    private boolean isSonos(RemoteDevice device) {
        return "urn:schemas-upnp-org:device:ZonePlayer:1".equals(device.getType().toString());
    }
}

