/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SecuritySettings {
    public static final String[] SEC_LEVEL_MANAGED_PROPERTIES = new String[]{"deployment.insecure.jres", "deployment.security.run.untrusted", "deployment.security.local.applets", "deployment.security.sandbox.selfsigned", "deployment.security.sandbox.casigned", "deployment.security.askgrantdialog.notinca", "deployment.security.revocation.check.best.effort", "deployment.security.permissions.manifest.required", "deployment.security.allow_expired_certs", "deployment.security.tls.revocation.check.best.effort"};
    public static final String[][] SEC_LEVEL_MAP8 = new String[][]{{"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"NEVER", "NEVER"}, {"PROMPT", "PROMPT"}, {"false", "false"}, {"true", "false"}, {"true", "true"}, {"false", "false"}, {"true", "false"}};
    public static final String[] SECURITY_LEVELS = new String[]{"HIGH", "VERY_HIGH"};
    public static final int LEVEL_HIGH_INDEX = 0;
    public static final int LEVEL_VERY_HIGH_INDEX = 1;
    public static final int LEVEL_DEFAULT_INDEX = 0;

    public static boolean isExpiredAllowed() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.allow_expired_certs");
    }

    public static boolean isSelfSignedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.sandbox.selfsigned"));
    }

    public static boolean isCaSignedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.sandbox.casigned"));
    }

    public static boolean isSSVModeNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModePrompt() {
        return "PROMPT".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isSSVModeMultiClick() {
        return "PROMPT_MULTI".equals(SecuritySettings.getManagedPropertyValue("deployment.insecure.jres"));
    }

    public static boolean isAskGrantShowSet() {
        return Config.getBooleanProperty("deployment.security.askgrantdialog.show");
    }

    public static boolean isAskGrantSelfSignedSet() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.askgrantdialog.notinca");
    }

    public static boolean isRunUntrustedNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static boolean isRunUntrustedMultiClick() {
        return "PROMPT_MULTI".equals(SecuritySettings.getManagedPropertyValue("deployment.security.run.untrusted"));
    }

    public static boolean isPermissionsManifestRequired() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.permissions.manifest.required");
    }

    public static boolean isRunLocalAppletsNever() {
        return "NEVER".equals(SecuritySettings.getManagedPropertyValue("deployment.security.local.applets"));
    }

    public static boolean isRevocationCheckBestEffort() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.revocation.check.best.effort");
    }

    public static boolean isTLSRevocationCheckBestEffort() {
        return SecuritySettings.getManagedBooleanValue("deployment.security.tls.revocation.check.best.effort");
    }

    public static String getManagedPropertyValue(String string) {
        int n = SecuritySettings.getSecurityLevelInt();
        int n2 = SecuritySettings.getPropertyIndex(string);
        if (n2 < 0) {
            Trace.println("Trying to call getManagedProperty(" + string + ");", TraceLevel.BASIC);
            return Config.getStringProperty(string);
        }
        return SEC_LEVEL_MAP8[n2][n];
    }

    public static boolean getManagedBooleanValue(String string) {
        return "true".equalsIgnoreCase(SecuritySettings.getManagedPropertyValue(string));
    }

    private static int getPropertyIndex(String string) {
        for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
            if (!SEC_LEVEL_MANAGED_PROPERTIES[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setSecurityLevel(String string) {
        Config.setStringProperty("deployment.security.level", string);
        for (int i = 0; i < SEC_LEVEL_MANAGED_PROPERTIES.length; ++i) {
            Config.get();
            Config.setStringProperty(SEC_LEVEL_MANAGED_PROPERTIES[i], null);
        }
    }

    public static String getSecurityLevel() {
        Config.get();
        return Config.getStringProperty("deployment.security.level");
    }

    public static int getSecurityLevelInt() {
        return SecuritySettings.getLevelInt(SecuritySettings.getSecurityLevel());
    }

    private static int getLevelInt(String string) {
        for (int i = 0; i < SECURITY_LEVELS.length; ++i) {
            if (!SECURITY_LEVELS[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public static void setInstallerRecommendedSecurityLevel(int n) {
        if (n >= 0 && n < SECURITY_LEVELS.length) {
            SecuritySettings.setSystemDeploymentProperty("deployment.security.level", SECURITY_LEVELS[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSystemDeploymentProperty(String string, String string2) {
        block8: {
            try {
                File file = new File(Config.getSystemHomePropertiesFile());
                Properties properties = new Properties();
                if (file.exists()) {
                    properties.load(new FileInputStream(file));
                }
                properties.setProperty(string, string2);
                new FileOutputStream(file);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                if (fileOutputStream == null) break block8;
                try {
                    properties.store(fileOutputStream, "System Deployment Properties");
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    fileOutputStream.flush();
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                fileOutputStream.flush();
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

