/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.security;

import com.sun.applet2.preloader.Preloader;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JNLPSigningException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.UnsignedAccessViolationException;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.SigningInfo;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JNLPSignedResourcesHelper {
    static final String SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING = "Signed jnlp file removed after signing.";
    static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    LaunchDesc mainDesc = null;
    private Thread warmupValidationThread = null;
    private boolean warmupOk = true;
    private static final String SIGNED_JNLP_ENTRY = "JNLP-INF/APPLICATION.JNLP";
    private static final String SIGNED_JNLP_TEMPLATE = "JNLP-INF/APPLICATION_TEMPLATE.JNLP";

    public JNLPSignedResourcesHelper(LaunchDesc launchDesc) {
        this.mainDesc = launchDesc;
        AppPolicy.createInstance(this.mainDesc.getCanonicalHome().getHost());
    }

    public synchronized void warmup() {
        if (this.warmupOk) {
            WarmupValidator warmupValidator = new WarmupValidator();
            this.warmupValidationThread = new Thread(warmupValidator);
            this.warmupValidationThread.setDaemon(true);
            this.warmupValidationThread.start();
        }
    }

    public void checkSignedLaunchDesc() throws IOException, JNLPException {
        this.checkSignedLaunchDesc(null, null);
    }

    public void checkSignedLaunchDesc(URL uRL, URL uRL2) throws IOException, JNLPException {
        ArrayList arrayList = new ArrayList();
        this.addExtensions(arrayList, this.mainDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            this.checkSignedLaunchDescHelper(launchDesc, uRL, uRL2);
        }
    }

    synchronized void ensureWarmupFinished() {
        if (this.warmupValidationThread != null) {
            try {
                this.warmupValidationThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.warmupValidationThread = null;
            this.warmupOk = false;
        }
    }

    public boolean checkSignedResources(Preloader preloader, boolean bl) throws IOException, JNLPException, ExitException {
        this.ensureWarmupFinished();
        boolean bl2 = true;
        ArrayList arrayList = new ArrayList();
        this.addExtensions(arrayList, this.mainDesc);
        for (int i = 0; i < arrayList.size(); ++i) {
            LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
            launchDesc.setParentURL(this.mainDesc.getParentURL());
            bl2 = JNLPSignedResourcesHelper.checkSignedResourcesHelper(launchDesc, preloader, bl) && bl2;
        }
        return bl2;
    }

    private void addExtensions(final ArrayList arrayList, LaunchDesc launchDesc) {
        if (launchDesc == null) {
            return;
        }
        arrayList.add(launchDesc);
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc != null) {
            resourcesDesc.visit(new ResourceVisitor(){

                public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                    if (!extensionDesc.isInstaller()) {
                        JNLPSignedResourcesHelper.this.addExtensions(arrayList, extensionDesc.getExtensionDesc());
                    }
                }
            });
        }
    }

    private void checkSignedLaunchDescHelper(LaunchDesc launchDesc, URL uRL, URL uRL2) throws IOException, JNLPException {
        block14: {
            boolean bl = launchDesc.isApplicationDescriptor();
            byte[] byArray = null;
            byte[] byArray2 = null;
            JNLPSigningException jNLPSigningException = null;
            try {
                byArray2 = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, bl, true);
                if (byArray2 != null) {
                    try {
                        launchDesc.checkSigningTemplate(byArray2);
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template matches LaunchDesc", (TraceLevel)TraceLevel.SECURITY);
                        }
                        return;
                    }
                    catch (JNLPSigningException jNLPSigningException2) {
                        if (DEBUG) {
                            Trace.println((String)"Signed JNLP Template fails to match ld", (TraceLevel)TraceLevel.SECURITY);
                        }
                        jNLPSigningException = jNLPSigningException2;
                    }
                }
                if ((byArray = JNLPSignedResourcesHelper.getSignedJNLPFile(launchDesc, bl, false)) == null) {
                    if (jNLPSigningException != null) {
                        throw jNLPSigningException;
                    }
                    break block14;
                }
                if (Arrays.equals(SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes(), byArray)) {
                    throw new JNLPSigningException(launchDesc, SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING);
                }
                LaunchDesc launchDesc2 = LaunchDescFactory.buildDescriptor(byArray, uRL, uRL2, launchDesc.getLocation());
                if (Trace.isEnabled((TraceLevel)TraceLevel.SECURITY)) {
                    Trace.println((String)"Downloaded JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)launchDesc.toString(), (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)"Signed JNLP file: ", (TraceLevel)TraceLevel.SECURITY);
                    Trace.println((String)launchDesc2.toString(), (TraceLevel)TraceLevel.SECURITY);
                }
                launchDesc.checkSigning(launchDesc2);
                return;
            }
            catch (LaunchDescException launchDescException) {
                launchDescException.setIsSignedLaunchDesc();
                throw launchDescException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (JNLPException jNLPException) {
                throw jNLPException;
            }
        }
        if (launchDesc.getCachedCertificates() != null && launchDesc.getCachedCertificates()[0].isSignedJNLP()) {
            throw new JNLPSigningException(launchDesc, null);
        }
    }

    public static boolean hasProgressResources(ResourcesDesc resourcesDesc) {
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        for (int i = 0; i < jARDescArray.length; ++i) {
            if (!jARDescArray[i].isProgressJar()) continue;
            return true;
        }
        return false;
    }

    private static boolean performSecurityCheckForSandbox(LaunchDesc launchDesc, Preloader preloader, CodeSource codeSource, boolean bl) throws ExitException {
        AppInfo appInfo = launchDesc.getAppInfo();
        try {
            if (bl) {
                appInfo.setPermissionAttrOverride();
            }
            SandboxSecurity.isPermissionGranted((CodeSource)codeSource, (AppInfo)appInfo, (DeploymentRuleSet)launchDesc.getMainDeploymentRuleSet(), (Preloader)preloader);
        }
        catch (SecurityException securityException) {
            throw new ExitException(securityException.getMessage(), securityException, 0);
        }
        finally {
            appInfo.unsetPermissionAttrOverride();
        }
        return launchDesc.isSecureJVMArgs();
    }

    private static boolean checkSignedResourcesHelper(LaunchDesc launchDesc, Preloader preloader, boolean bl) throws IOException, JNLPException, ExitException {
        Object object;
        Object object2;
        int n;
        boolean bl2;
        Object object3;
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return true;
        }
        if (bl && !JNLPSignedResourcesHelper.hasProgressResources(resourcesDesc)) {
            return true;
        }
        CodeSource codeSource = null;
        if (launchDesc.isSecure() && ((codeSource = JNLPSignedResourcesHelper.getMainJarCodeSource(launchDesc, bl)) == null || codeSource.getCertificates() == null || !Config.isJavaVersionAtLeast16())) {
            return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(launchDesc, preloader, codeSource, bl);
        }
        JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = true;
        boolean bl6 = true;
        List list = null;
        URL uRL = launchDesc.getCanonicalHome();
        int n2 = 0;
        URL uRL2 = null;
        SigningInfo signingInfo = null;
        Map map = null;
        if (DEBUG) {
            Trace.println((String)("Validating signatures for " + launchDesc.getLocation() + " " + launchDesc.getSourceURL()), (TraceLevel)TraceLevel.SECURITY);
        }
        if (launchDesc.getLocation() != null) {
            object3 = launchDesc.getSourceURL();
            if (object3 == null) {
                object3 = launchDesc.getLocation();
            }
            signingInfo = new SigningInfo((URL)object3, launchDesc.getVersion());
            map = signingInfo.getTrustedEntries();
            if (DEBUG) {
                Trace.println((String)("TrustedSet " + (map != null ? Integer.toString(map.size()) : "null")), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        object3 = new SigningInfo[jARDescArray.length];
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        boolean bl7 = false;
        if (map == null) {
            bl2 = false;
            if (DEBUG) {
                Trace.println((String)("Empty trusted set for [" + uRL + "]"), (TraceLevel)TraceLevel.SECURITY);
            }
        } else {
            bl2 = true;
        }
        for (n = 0; !bl7 && n < jARDescArray.length; ++n) {
            object2 = jARDescArray[n];
            object3[n] = new SigningInfo(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
            if (DEBUG) {
                Trace.println((String)("Round 1 (" + n + " out of " + jARDescArray.length + "):" + ((JARDesc)object2).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
            }
            if (object3[n].isFileKnownToBeNotCached()) {
                if (DEBUG) {
                    Trace.println((String)("    Skip: " + ((JARDesc)object2).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                }
                bl4 = true;
                continue;
            }
            if (object3[n].isKnownToBeValidated()) {
                long l = object3[n].getCachedVerificationTimestampt();
                String string = ((JARDesc)object2).getLocationString();
                if (!object3[n].isKnownToBeSigned()) {
                    bl7 = true;
                    bl2 = false;
                    continue;
                }
                if (bl2 && ((object = (Long)map.get(string)) == null || (Long)object != l)) {
                    if (DEBUG) {
                        Trace.println((String)("Entry [" + string + ", " + object + "] does not match trusted set. Revert to full validation of JNLP."), (TraceLevel)TraceLevel.SECURITY);
                    }
                    bl2 = false;
                }
                hashMap.put(string, new Long(l));
                continue;
            }
            bl7 = true;
            bl2 = false;
            if (!DEBUG) continue;
            Trace.println((String)("Entry [" + ((JARDesc)object2).getLocationString() + "] is not prevalidated. Revert to full validation of this JAR."), (TraceLevel)TraceLevel.SECURITY);
        }
        if (!bl2) {
            URL uRL3;
            bl6 = false;
            for (n = 0; n < jARDescArray.length && bl5; ++n) {
                object2 = jARDescArray[n];
                if (DEBUG) {
                    Trace.println((String)("Round 2 (" + n + " out of " + jARDescArray.length + "):" + ((JARDesc)object2).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                }
                if (object3[n] == null) {
                    object3[n] = new SigningInfo(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
                }
                if (object3[n].isFileKnownToBeNotCached()) {
                    if (DEBUG) {
                        Trace.println((String)("    Skip " + ((JARDesc)object2).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                    }
                    bl4 = true;
                    continue;
                }
                List list2 = null;
                list2 = object3[n].isKnownToBeValidated() ? object3[n].getCertificates() : object3[n].check();
                if (object3[n].isJarKnownToBeEmpty()) continue;
                bl6 = true;
                if (list2 == null) {
                    bl3 = false;
                    uRL2 = ((JARDesc)object2).getLocation();
                    if (launchDesc.getSecurityModel() == 0) break;
                    uRL3 = ResourceProvider.get().getCachedResource(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
                    ResourceProvider.get().markRetired((Resource)uRL3, true);
                    break;
                }
                if (list == null) {
                    list = list2;
                } else {
                    list = SigningInfo.overlapChainLists(list2, list);
                    if (DEBUG) {
                        Trace.println((String)("Have " + (list == null ? 0 : list.size()) + " common certificates after processing " + ((JARDesc)object2).getLocationString()), (TraceLevel)TraceLevel.SECURITY);
                    }
                    if (list == null) {
                        bl5 = false;
                        if (launchDesc.getSecurityModel() != 0) {
                            Resource resource = ResourceProvider.get().getCachedResource(((JARDesc)object2).getLocation(), ((JARDesc)object2).getVersion());
                            ResourceProvider.get().markRetired(resource, true);
                        }
                    }
                }
                long l = object3[n].getCachedVerificationTimestampt();
                object = ((JARDesc)object2).getLocationString();
                hashMap.put(object, new Long(l));
                ++n2;
            }
            if (!bl5) {
                throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.singlecertviolation"), null);
            }
            if (!launchDesc.isSecure()) {
                if (!bl3) {
                    throw new UnsignedAccessViolationException(launchDesc, uRL2, true);
                }
                List list3 = JNLPSignedResourcesHelper.normalizeCertificateList(list);
                if (launchDesc.getCachedCertificates() != null) {
                    object2 = launchDesc.getCachedCertificates();
                    for (int i = 0; i < ((CachedCertificatesHelper[])object2).length; ++i) {
                        JNLPSignedResourcesHelper.checkCachedChain(launchDesc, list3, object2[i].getCertPath());
                    }
                }
                if (n2 > 0) {
                    object2 = null;
                    JARDesc jARDesc = launchDesc.getResources().getMainJar(true);
                    uRL3 = jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome();
                    object2 = Config.isJavaVersionAtLeast15() ? new CodeSource(uRL3, list.toArray(new CodeSigner[list.size()])) : new CodeSource(uRL3, list3.toArray(new Certificate[list3.size()]));
                    long l = AppPolicy.getInstance().grantUnrestrictedAccess(launchDesc, launchDesc.getMainDeploymentRuleSet(), (CodeSource)object2, preloader, bl);
                    if (l > 0L) {
                        long l2 = System.currentTimeMillis();
                        for (int i = 0; i < ((SigningInfo[])object3).length; ++i) {
                            object3[i].updateCacheIfNeeded(true, null, l2, l);
                            String string = jARDescArray[i].getLocationString();
                            if (!hashMap.containsKey(string)) continue;
                            hashMap.put(string, new Long(object3[i].getCachedVerificationTimestampt()));
                        }
                        if (signingInfo != null) {
                            signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), l);
                        }
                    }
                    bl2 = true;
                } else {
                    if (signingInfo != null) {
                        signingInfo.updateCache(true, hashMap, System.currentTimeMillis(), Long.MAX_VALUE);
                    }
                    bl2 = true;
                }
            } else {
                return JNLPSignedResourcesHelper.performSecurityCheckForSandbox(launchDesc, preloader, codeSource, bl);
            }
        }
        if (bl2 && !bl4 && bl6) {
            launchDesc.setTrusted();
        }
        if (DEBUG) {
            Trace.println((String)("LD - All JAR files signed: " + uRL), (TraceLevel)TraceLevel.BASIC);
        }
        return bl3;
    }

    static byte[] getSignedJNLPFile(LaunchDesc launchDesc, boolean bl, boolean bl2) throws IOException, JNLPException {
        if (launchDesc.getResources() == null || launchDesc.isLibrary()) {
            return null;
        }
        JARDesc jARDesc = launchDesc.getResources().getMainJar(bl);
        if (jARDesc == null) {
            return null;
        }
        return JNLPSignedResourcesHelper.getSignedJNLPBits(jARDesc.getLocation(), jARDesc.getVersion(), bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSignedJNLPBits(URL uRL, String string, boolean bl) throws IOException {
        String string2 = bl ? SIGNED_JNLP_TEMPLATE : SIGNED_JNLP_ENTRY;
        ZipFile zipFile = null;
        try {
            Object object;
            Object object2;
            zipFile = new JarFile(ResourceProvider.get().getCachedResourceFilePath(uRL, string), false);
            Object object3 = ((JarFile)zipFile).getJarEntry(string2);
            if (object3 == null) {
                object2 = ((JarFile)zipFile).entries();
                while (object2.hasMoreElements() && object3 == null) {
                    object = (JarEntry)object2.nextElement();
                    if (!((ZipEntry)object).getName().equalsIgnoreCase(string2)) continue;
                    object3 = object;
                }
            }
            if (object3 == null) {
                if (JNLPSignedResourcesHelper.hasSigningEntryForFile((JarFile)zipFile, string2)) {
                    Trace.println((String)("Signed jnlp file: " + string2 + "was removed from jar file: " + uRL), (TraceLevel)TraceLevel.SECURITY);
                    object2 = SIGNED_JNLP_FILE_REMOVED_AFTER_SIGNING.getBytes();
                    return object2;
                }
                object2 = null;
                return object2;
            }
            object2 = new byte[(int)((ZipEntry)object3).getSize()];
            object = new DataInputStream(((JarFile)zipFile).getInputStream((ZipEntry)object3));
            ((DataInputStream)object).readFully((byte[])object2, 0, (int)((ZipEntry)object3).getSize());
            ((FilterInputStream)object).close();
            Object object4 = object2;
            return object4;
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static boolean hasSigningEntryForFile(JarFile jarFile, String string) {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName().toUpperCase(Locale.ENGLISH);
            if (!string2.startsWith("META-INF/") || !string2.endsWith(".SF")) continue;
            try {
                Manifest manifest = new Manifest(jarFile.getInputStream(jarEntry));
                for (String string3 : manifest.getEntries().keySet()) {
                    if (!string.equalsIgnoreCase(string3)) continue;
                    return true;
                }
            }
            catch (IOException iOException) {
                Trace.ignored((Throwable)iOException);
            }
        }
        return false;
    }

    static void checkCachedChain(LaunchDesc launchDesc, List list, CertPath certPath) throws LaunchDescException {
        if (list == null) {
            return;
        }
        List<? extends Certificate> list2 = certPath.getCertificates();
        for (int i = 0; i < list2.size(); ++i) {
            Certificate certificate = list2.get(i);
            if (list.contains(certificate)) continue;
            throw new LaunchDescException(launchDesc, ResourceManager.getString((String)"launch.error.unmatched.embedded.cert"), null);
        }
    }

    static List normalizeCertificateList(List list) {
        ArrayList<? extends Certificate> arrayList = new ArrayList<Certificate>();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                if (Config.isJavaVersionAtLeast15() && list.get(i) instanceof CodeSigner) {
                    object = (CodeSigner)list.get(i);
                    CertPath certPath = ((CodeSigner)object).getSignerCertPath();
                    if (certPath == null) continue;
                    arrayList.addAll(certPath.getCertificates());
                    continue;
                }
                if (!(list.get(i) instanceof SigningInfo.CertChain)) continue;
                object = (SigningInfo.CertChain)list.get(i);
                arrayList.addAll(Arrays.asList(((SigningInfo.CertChain)object).getCertificates()));
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static CodeSource getMainJarCodeSource(LaunchDesc launchDesc, boolean bl) {
        Certificate[] certificateArray = null;
        CodeSigner[] codeSignerArray = null;
        JARDesc jARDesc = null;
        jARDesc = bl ? launchDesc.getResources().getProgressJar() : launchDesc.getResources().getMainJar(true);
        if (jARDesc != null) {
            try {
                SigningInfo signingInfo = new SigningInfo(jARDesc.getLocation(), jARDesc.getVersion());
                if (Config.isJavaVersionAtLeast15()) {
                    List list = signingInfo.check();
                    codeSignerArray = list.toArray(new CodeSigner[list.size()]);
                } else {
                    List list = JNLPSignedResourcesHelper.normalizeCertificateList(signingInfo.check());
                    certificateArray = list.toArray(new Certificate[list.size()]);
                }
            }
            catch (SecurityException securityException) {
                throw securityException;
            }
            catch (Exception exception) {
                Trace.println((String)("Treat jar as unsigned due to exception: " + exception), (TraceLevel)TraceLevel.SECURITY);
            }
        }
        if (Config.isJavaVersionAtLeast15()) {
            return new CodeSource(jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome(), codeSignerArray);
        }
        return new CodeSource(jARDesc != null ? jARDesc.getLocation() : launchDesc.getCanonicalHome(), certificateArray);
    }

    class WarmupValidator
    implements Runnable {
        WarmupValidator() {
        }

        public void run() {
            if (DEBUG) {
                Trace.println((String)"Staring warmup validation", (TraceLevel)TraceLevel.SECURITY);
            }
            ArrayList arrayList = new ArrayList();
            JNLPSignedResourcesHelper.this.addExtensions(arrayList, JNLPSignedResourcesHelper.this.mainDesc);
            for (int i = 0; i < arrayList.size(); ++i) {
                LaunchDesc launchDesc = (LaunchDesc)arrayList.get(i);
                try {
                    this.processSingleDesc(launchDesc);
                    continue;
                }
                catch (Exception exception) {
                    Trace.ignored((Throwable)exception);
                }
            }
        }

        private void processSingleDesc(LaunchDesc launchDesc) throws GeneralSecurityException, IOException {
            CachedCertificatesHelper[] cachedCertificatesHelperArray = launchDesc.getCachedCertificates();
            if (cachedCertificatesHelperArray != null) {
                for (int i = 0; i < cachedCertificatesHelperArray.length; ++i) {
                    Certificate[] certificateArray = cachedCertificatesHelperArray[i].getCertPath().getCertificates().toArray(new X509Certificate[0]);
                    CodeSource codeSource = new CodeSource(launchDesc.getCanonicalHome(), certificateArray);
                    TrustDecider.validateChainForWarmup((X509Certificate[])certificateArray, (CodeSource)codeSource, (int)i, (AppInfo)launchDesc.getAppInfo(), (DeploymentRuleSet)launchDesc.getMainDeploymentRuleSet());
                }
            }
        }
    }
}

