/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Label;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.AccessNode;
import jdk.nashorn.internal.ir.BaseNode;
import jdk.nashorn.internal.ir.BinaryNode;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.BreakableNode;
import jdk.nashorn.internal.ir.CaseNode;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.IfNode;
import jdk.nashorn.internal.ir.IndexNode;
import jdk.nashorn.internal.ir.JoinPredecessor;
import jdk.nashorn.internal.ir.JoinPredecessorExpression;
import jdk.nashorn.internal.ir.JumpStatement;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LexicalContextNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.LocalVariableConversion;
import jdk.nashorn.internal.ir.LoopNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.RuntimeNode;
import jdk.nashorn.internal.ir.SplitReturn;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.TernaryNode;
import jdk.nashorn.internal.ir.ThrowNode;
import jdk.nashorn.internal.ir.TryNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.ir.VarNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.TokenType;

final class LocalVariableTypesCalculator
extends NodeVisitor<LexicalContext> {
    private static final Map<Type, LvarType> TO_LVAR_TYPE = new IdentityHashMap<Type, LvarType>();
    private final Compiler compiler;
    private final Map<Label, JumpTarget> jumpTargets = new IdentityHashMap<Label, JumpTarget>();
    private Map<Symbol, LvarType> localVariableTypes = new IdentityHashMap<Symbol, LvarType>();
    private boolean reachable = true;
    private Type returnType = Type.UNKNOWN;
    private ReturnNode syntheticReturn;
    private boolean alreadyEnteredTopLevelFunction;
    private final Map<JoinPredecessor, LocalVariableConversion> localVariableConversions = new IdentityHashMap<JoinPredecessor, LocalVariableConversion>();
    private final Map<IdentNode, LvarType> identifierLvarTypes = new IdentityHashMap<IdentNode, LvarType>();
    private final Map<Symbol, SymbolConversions> symbolConversions = new IdentityHashMap<Symbol, SymbolConversions>();
    private SymbolToType symbolToType = new SymbolToType();
    private final Deque<Label> catchLabels = new ArrayDeque<Label>();

    private static IdentityHashMap<Symbol, LvarType> cloneMap(Map<Symbol, LvarType> map) {
        return (IdentityHashMap)((IdentityHashMap)map).clone();
    }

    private LocalVariableConversion createConversion(Symbol symbol, LvarType branchLvarType, Map<Symbol, LvarType> joinLvarTypes, LocalVariableConversion next) {
        LvarType targetType = joinLvarTypes.get(symbol);
        assert (targetType != null);
        if (targetType == branchLvarType) {
            return next;
        }
        this.symbolIsConverted(symbol, branchLvarType, targetType);
        return new LocalVariableConversion(symbol, branchLvarType.type, targetType.type, next);
    }

    private static Map<Symbol, LvarType> getUnionTypes(Map<Symbol, LvarType> types1, Map<Symbol, LvarType> types2) {
        IdentityHashMap<Symbol, LvarType> union;
        if (types1 == types2 || types1.isEmpty()) {
            return types2;
        }
        if (types2.isEmpty()) {
            return types1;
        }
        HashSet<Symbol> commonSymbols = new HashSet<Symbol>(types1.keySet());
        commonSymbols.retainAll(types2.keySet());
        int commonSize = commonSymbols.size();
        int types1Size = types1.size();
        int types2Size = types2.size();
        if (commonSize == types1Size && commonSize == types2Size) {
            boolean matches1 = true;
            boolean matches2 = true;
            IdentityHashMap<Symbol, LvarType> union2 = null;
            for (Symbol symbol : commonSymbols) {
                LvarType type2;
                LvarType type1 = types1.get(symbol);
                LvarType widest = LocalVariableTypesCalculator.widestLvarType(type1, type2 = types2.get(symbol));
                if (widest != type1 && matches1) {
                    matches1 = false;
                    if (!matches2) {
                        union2 = LocalVariableTypesCalculator.cloneMap(types1);
                    }
                }
                if (widest != type2 && matches2) {
                    matches2 = false;
                    if (!matches1) {
                        union2 = LocalVariableTypesCalculator.cloneMap(types2);
                    }
                }
                if (matches1 || matches2 || union2 == null) continue;
                assert (union2 != null);
                union2.put(symbol, widest);
            }
            return matches1 ? types1 : (matches2 ? types2 : union2);
        }
        if (types1Size > types2Size) {
            union = LocalVariableTypesCalculator.cloneMap(types1);
            union.putAll(types2);
        } else {
            union = LocalVariableTypesCalculator.cloneMap(types2);
            union.putAll(types1);
        }
        for (Symbol symbol : commonSymbols) {
            LvarType type1 = types1.get(symbol);
            LvarType type2 = types2.get(symbol);
            union.put(symbol, LocalVariableTypesCalculator.widestLvarType(type1, type2));
        }
        return union;
    }

    private static void symbolIsUsed(Symbol symbol, LvarType type) {
        if (type != LvarType.UNDEFINED) {
            symbol.setHasSlotFor(type.type);
        }
    }

    private void symbolIsConverted(Symbol symbol, LvarType from, LvarType to) {
        SymbolConversions conversions = this.symbolConversions.get(symbol);
        if (conversions == null) {
            conversions = new SymbolConversions();
            this.symbolConversions.put(symbol, conversions);
        }
        conversions.recordConversion(from, to);
    }

    private static LvarType toLvarType(Type type) {
        assert (type != null);
        LvarType lvarType = TO_LVAR_TYPE.get(type);
        if (lvarType != null) {
            return lvarType;
        }
        assert (type.isObject());
        return LvarType.OBJECT;
    }

    private static LvarType widestLvarType(LvarType t1, LvarType t2) {
        if (t1 == t2) {
            return t1;
        }
        if (t1.ordinal() < LvarType.INT.ordinal() || t2.ordinal() < LvarType.INT.ordinal()) {
            return LvarType.OBJECT;
        }
        return LvarType.values()[Math.max(t1.ordinal(), t2.ordinal())];
    }

    LocalVariableTypesCalculator(Compiler compiler) {
        super(new LexicalContext());
        this.compiler = compiler;
    }

    private JumpTarget createJumpTarget(Label label) {
        assert (!this.jumpTargets.containsKey(label));
        JumpTarget jumpTarget = new JumpTarget();
        this.jumpTargets.put(label, jumpTarget);
        return jumpTarget;
    }

    private void doesNotContinueSequentially() {
        this.reachable = false;
        this.localVariableTypes = Collections.emptyMap();
    }

    @Override
    public boolean enterBinaryNode(BinaryNode binaryNode) {
        Label joinLabel;
        Expression lhs = binaryNode.lhs();
        boolean isAssignment = binaryNode.isAssignment();
        LvarType lhsTypeOnLoad = null;
        if (isAssignment) {
            if (lhs instanceof BaseNode) {
                ((BaseNode)lhs).getBase().accept(this);
                if (lhs instanceof IndexNode) {
                    ((IndexNode)lhs).getIndex().accept(this);
                } else assert (lhs instanceof AccessNode);
            } else {
                assert (lhs instanceof IdentNode);
                if (binaryNode.isSelfModifying()) {
                    IdentNode ident = (IdentNode)lhs;
                    ident.accept(this);
                    lhsTypeOnLoad = this.getLocalVariableTypeIfBytecode(ident.getSymbol());
                }
            }
        } else {
            lhs.accept(this);
        }
        boolean isLogical = binaryNode.isLogical();
        assert (!isAssignment || !isLogical);
        Label label = joinLabel = isLogical ? new Label("") : null;
        if (isLogical) {
            this.jumpToLabel((JoinPredecessor)((Object)lhs), joinLabel);
        }
        Expression rhs = binaryNode.rhs();
        rhs.accept(this);
        if (isLogical) {
            this.jumpToLabel((JoinPredecessor)((Object)rhs), joinLabel);
        }
        this.joinOnLabel(joinLabel);
        if (isAssignment && lhs instanceof IdentNode) {
            if (binaryNode.isSelfModifying()) {
                this.onSelfAssignment((IdentNode)lhs, binaryNode, lhsTypeOnLoad);
            } else {
                this.onAssignment((IdentNode)lhs, rhs);
            }
        }
        return false;
    }

    @Override
    public boolean enterBlock(Block block) {
        for (Symbol symbol : block.getSymbols()) {
            if (!symbol.isBytecodeLocal() || this.getLocalVariableTypeOrNull(symbol) != null) continue;
            this.setType(symbol, LvarType.UNDEFINED);
        }
        return true;
    }

    @Override
    public boolean enterBreakNode(BreakNode breakNode) {
        return this.enterJumpStatement(breakNode);
    }

    @Override
    public boolean enterContinueNode(ContinueNode continueNode) {
        return this.enterJumpStatement(continueNode);
    }

    private boolean enterJumpStatement(JumpStatement jump) {
        if (!this.reachable) {
            return false;
        }
        BreakableNode target = jump.getTarget(this.lc);
        this.jumpToLabel(jump, jump.getTargetLabel(target), this.getBreakTargetTypes(target));
        this.doesNotContinueSequentially();
        return false;
    }

    @Override
    protected boolean enterDefault(Node node) {
        return this.reachable;
    }

    private void enterDoWhileLoop(WhileNode loopNode) {
        JoinPredecessorExpression test = loopNode.getTest();
        Block body = loopNode.getBody();
        Label continueLabel = loopNode.getContinueLabel();
        Label breakLabel = loopNode.getBreakLabel();
        Map<Symbol, LvarType> beforeLoopTypes = this.localVariableTypes;
        Label repeatLabel = new Label("");
        while (true) {
            this.jumpToLabel(loopNode, repeatLabel, beforeLoopTypes);
            Map<Symbol, LvarType> beforeRepeatTypes = this.localVariableTypes;
            body.accept(this);
            if (this.reachable) {
                this.jumpToLabel(body, continueLabel);
            }
            this.joinOnLabel(continueLabel);
            if (!this.reachable) break;
            test.accept(this);
            this.jumpToLabel(test, breakLabel);
            if (Expression.isAlwaysFalse(test)) break;
            this.jumpToLabel(test, repeatLabel);
            this.joinOnLabel(repeatLabel);
            if (this.localVariableTypes.equals(beforeRepeatTypes)) break;
            this.resetJoinPoint(continueLabel);
            this.resetJoinPoint(breakLabel);
            this.resetJoinPoint(repeatLabel);
        }
        if (Expression.isAlwaysTrue(test)) {
            this.doesNotContinueSequentially();
        }
        this.leaveBreakable(loopNode);
    }

    @Override
    public boolean enterForNode(ForNode forNode) {
        if (!this.reachable) {
            return false;
        }
        Expression init = forNode.getInit();
        if (forNode.isForIn()) {
            JoinPredecessorExpression iterable = forNode.getModify();
            iterable.accept(this);
            this.enterTestFirstLoop(forNode, null, init, !this.compiler.useOptimisticTypes() || !forNode.isForEach() && this.compiler.hasStringPropertyIterator(iterable.getExpression()));
        } else {
            if (init != null) {
                init.accept(this);
            }
            this.enterTestFirstLoop(forNode, forNode.getModify(), null, false);
        }
        return false;
    }

    @Override
    public boolean enterFunctionNode(FunctionNode functionNode) {
        if (this.alreadyEnteredTopLevelFunction) {
            return false;
        }
        int pos = 0;
        if (!functionNode.isVarArg()) {
            for (IdentNode param : functionNode.getParameters()) {
                Symbol symbol = param.getSymbol();
                assert (symbol.hasSlot());
                Type callSiteParamType = this.compiler.getParamType(functionNode, pos);
                LvarType paramType = callSiteParamType == null ? LvarType.OBJECT : LocalVariableTypesCalculator.toLvarType(callSiteParamType);
                this.setType(symbol, paramType);
                this.symbolIsUsed(symbol);
                this.setIdentifierLvarType(param, paramType);
                ++pos;
            }
        }
        this.setCompilerConstantAsObject(functionNode, CompilerConstants.THIS);
        if (functionNode.hasScopeBlock() || functionNode.needsParentScope()) {
            this.setCompilerConstantAsObject(functionNode, CompilerConstants.SCOPE);
        }
        if (functionNode.needsCallee()) {
            this.setCompilerConstantAsObject(functionNode, CompilerConstants.CALLEE);
        }
        if (functionNode.needsArguments()) {
            this.setCompilerConstantAsObject(functionNode, CompilerConstants.ARGUMENTS);
        }
        this.alreadyEnteredTopLevelFunction = true;
        return true;
    }

    @Override
    public boolean enterIdentNode(IdentNode identNode) {
        Symbol symbol = identNode.getSymbol();
        if (symbol.isBytecodeLocal()) {
            this.symbolIsUsed(symbol);
            this.setIdentifierLvarType(identNode, this.getLocalVariableType(symbol));
        }
        return false;
    }

    @Override
    public boolean enterIfNode(IfNode ifNode) {
        if (!this.reachable) {
            return false;
        }
        Expression test = ifNode.getTest();
        Block pass = ifNode.getPass();
        Block fail = ifNode.getFail();
        test.accept(this);
        Map<Symbol, LvarType> afterTestLvarTypes = this.localVariableTypes;
        if (!Expression.isAlwaysFalse(test)) {
            pass.accept(this);
        }
        Map<Symbol, LvarType> passLvarTypes = this.localVariableTypes;
        boolean reachableFromPass = this.reachable;
        this.reachable = true;
        this.localVariableTypes = afterTestLvarTypes;
        if (!Expression.isAlwaysTrue(test) && fail != null) {
            fail.accept(this);
            boolean reachableFromFail = this.reachable;
            this.reachable |= reachableFromPass;
            if (!this.reachable) {
                return false;
            }
            if (reachableFromFail) {
                if (reachableFromPass) {
                    Map<Symbol, LvarType> failLvarTypes = this.localVariableTypes;
                    this.localVariableTypes = LocalVariableTypesCalculator.getUnionTypes(passLvarTypes, failLvarTypes);
                    this.setConversion(pass, passLvarTypes, this.localVariableTypes);
                    this.setConversion(fail, failLvarTypes, this.localVariableTypes);
                }
                return false;
            }
        }
        if (reachableFromPass) {
            this.localVariableTypes = LocalVariableTypesCalculator.getUnionTypes(afterTestLvarTypes, passLvarTypes);
            this.setConversion(pass, passLvarTypes, this.localVariableTypes);
            this.setConversion(ifNode, afterTestLvarTypes, this.localVariableTypes);
        } else {
            this.localVariableTypes = afterTestLvarTypes;
        }
        return false;
    }

    @Override
    public boolean enterPropertyNode(PropertyNode propertyNode) {
        if (propertyNode.getValue() != null) {
            propertyNode.getValue().accept(this);
        }
        return false;
    }

    @Override
    public boolean enterReturnNode(ReturnNode returnNode) {
        Type returnExprType;
        if (!this.reachable) {
            return false;
        }
        Expression returnExpr = returnNode.getExpression();
        if (returnExpr != null) {
            returnExpr.accept(this);
            returnExprType = this.getType(returnExpr);
        } else {
            returnExprType = Type.UNDEFINED;
        }
        this.returnType = Type.widestReturnType(this.returnType, returnExprType);
        this.doesNotContinueSequentially();
        return false;
    }

    @Override
    public boolean enterSplitReturn(SplitReturn splitReturn) {
        this.doesNotContinueSequentially();
        return false;
    }

    @Override
    public boolean enterSwitchNode(SwitchNode switchNode) {
        if (!this.reachable) {
            return false;
        }
        Expression expr = switchNode.getExpression();
        expr.accept(this);
        List<CaseNode> cases = switchNode.getCases();
        if (cases.isEmpty()) {
            return false;
        }
        boolean isInteger = switchNode.isUniqueInteger();
        Label breakLabel = switchNode.getBreakLabel();
        boolean hasDefault = switchNode.getDefaultCase() != null;
        boolean tagUsed = false;
        for (CaseNode caseNode : cases) {
            Expression test = caseNode.getTest();
            if (!isInteger && test != null) {
                test.accept(this);
                if (!tagUsed) {
                    LocalVariableTypesCalculator.symbolIsUsed(switchNode.getTag(), LvarType.OBJECT);
                    tagUsed = true;
                }
            }
            this.jumpToLabel(caseNode, caseNode.getBody().getEntryLabel());
        }
        if (!hasDefault) {
            this.jumpToLabel(switchNode, breakLabel);
        }
        this.doesNotContinueSequentially();
        Block previousBlock = null;
        for (CaseNode caseNode : cases) {
            Block body = caseNode.getBody();
            Label entryLabel = body.getEntryLabel();
            if (previousBlock != null && this.reachable) {
                this.jumpToLabel(previousBlock, entryLabel);
            }
            this.joinOnLabel(entryLabel);
            assert (this.reachable);
            body.accept(this);
            previousBlock = body;
        }
        if (previousBlock != null && this.reachable) {
            this.jumpToLabel(previousBlock, breakLabel);
        }
        this.leaveBreakable(switchNode);
        return false;
    }

    @Override
    public boolean enterTernaryNode(TernaryNode ternaryNode) {
        Expression test = ternaryNode.getTest();
        JoinPredecessorExpression trueExpr = ternaryNode.getTrueExpression();
        JoinPredecessorExpression falseExpr = ternaryNode.getFalseExpression();
        test.accept(this);
        Map<Symbol, LvarType> testExitLvarTypes = this.localVariableTypes;
        if (!Expression.isAlwaysFalse(test)) {
            ((Node)trueExpr).accept(this);
        }
        Map<Symbol, LvarType> trueExitLvarTypes = this.localVariableTypes;
        this.localVariableTypes = testExitLvarTypes;
        if (!Expression.isAlwaysTrue(test)) {
            ((Node)falseExpr).accept(this);
        }
        Map<Symbol, LvarType> falseExitLvarTypes = this.localVariableTypes;
        this.localVariableTypes = LocalVariableTypesCalculator.getUnionTypes(trueExitLvarTypes, falseExitLvarTypes);
        this.setConversion(trueExpr, trueExitLvarTypes, this.localVariableTypes);
        this.setConversion(falseExpr, falseExitLvarTypes, this.localVariableTypes);
        return false;
    }

    private void enterTestFirstLoop(LoopNode loopNode, JoinPredecessorExpression modify, Expression iteratorValues, boolean iteratorValuesAreObject) {
        JoinPredecessorExpression test = loopNode.getTest();
        if (Expression.isAlwaysFalse(test)) {
            test.accept(this);
            return;
        }
        Label continueLabel = loopNode.getContinueLabel();
        Label breakLabel = loopNode.getBreakLabel();
        Label repeatLabel = modify == null ? continueLabel : new Label("");
        Map<Symbol, LvarType> beforeLoopTypes = this.localVariableTypes;
        while (true) {
            this.jumpToLabel(loopNode, repeatLabel, beforeLoopTypes);
            Map<Symbol, LvarType> beforeRepeatTypes = this.localVariableTypes;
            if (test != null) {
                test.accept(this);
            }
            if (!Expression.isAlwaysTrue(test)) {
                this.jumpToLabel(test, breakLabel);
            }
            if (iteratorValues instanceof IdentNode) {
                IdentNode ident = (IdentNode)iteratorValues;
                this.onAssignment(ident, iteratorValuesAreObject ? LvarType.OBJECT : LocalVariableTypesCalculator.toLvarType(this.compiler.getOptimisticType(ident)));
            }
            Block body = loopNode.getBody();
            body.accept(this);
            if (this.reachable) {
                this.jumpToLabel(body, continueLabel);
            }
            this.joinOnLabel(continueLabel);
            if (!this.reachable) break;
            if (modify != null) {
                modify.accept(this);
                this.jumpToLabel(modify, repeatLabel);
                this.joinOnLabel(repeatLabel);
            }
            if (this.localVariableTypes.equals(beforeRepeatTypes)) break;
            this.resetJoinPoint(continueLabel);
            this.resetJoinPoint(breakLabel);
            this.resetJoinPoint(repeatLabel);
        }
        if (Expression.isAlwaysTrue(test) && iteratorValues == null) {
            this.doesNotContinueSequentially();
        }
        this.leaveBreakable(loopNode);
    }

    @Override
    public boolean enterThrowNode(ThrowNode throwNode) {
        if (!this.reachable) {
            return false;
        }
        throwNode.getExpression().accept(this);
        this.jumpToCatchBlock(throwNode);
        this.doesNotContinueSequentially();
        return false;
    }

    @Override
    public boolean enterTryNode(TryNode tryNode) {
        if (!this.reachable) {
            return false;
        }
        Label catchLabel = new Label("");
        this.catchLabels.push(catchLabel);
        this.jumpToLabel(tryNode, catchLabel);
        Block body = tryNode.getBody();
        body.accept(this);
        this.catchLabels.pop();
        Label endLabel = new Label("");
        boolean canExit = false;
        if (this.reachable) {
            this.jumpToLabel(body, endLabel);
            canExit = true;
        }
        this.doesNotContinueSequentially();
        this.joinOnLabel(catchLabel);
        for (CatchNode catchNode : tryNode.getCatches()) {
            IdentNode exception = catchNode.getException();
            this.onAssignment(exception, LvarType.OBJECT);
            Expression condition = catchNode.getExceptionCondition();
            if (condition != null) {
                condition.accept(this);
            }
            Map<Symbol, LvarType> afterConditionTypes = this.localVariableTypes;
            Block catchBody = catchNode.getBody();
            this.reachable = true;
            catchBody.accept(this);
            Symbol exceptionSymbol = exception.getSymbol();
            if (this.reachable) {
                this.localVariableTypes = LocalVariableTypesCalculator.cloneMap(this.localVariableTypes);
                this.localVariableTypes.remove(exceptionSymbol);
                this.jumpToLabel(catchBody, endLabel);
                canExit = true;
            }
            this.localVariableTypes = LocalVariableTypesCalculator.cloneMap(afterConditionTypes);
            this.localVariableTypes.remove(exceptionSymbol);
        }
        this.doesNotContinueSequentially();
        if (canExit) {
            this.joinOnLabel(endLabel);
        }
        return false;
    }

    @Override
    public boolean enterUnaryNode(UnaryNode unaryNode) {
        Expression expr = unaryNode.getExpression();
        expr.accept(this);
        if (unaryNode.isSelfModifying() && expr instanceof IdentNode) {
            IdentNode ident = (IdentNode)expr;
            this.onSelfAssignment(ident, unaryNode, this.getLocalVariableTypeIfBytecode(ident.getSymbol()));
        }
        return false;
    }

    @Override
    public boolean enterVarNode(VarNode varNode) {
        if (!this.reachable) {
            return false;
        }
        Expression init = varNode.getInit();
        if (init != null) {
            init.accept(this);
            this.onAssignment(varNode.getName(), init);
        }
        return false;
    }

    @Override
    public boolean enterWhileNode(WhileNode whileNode) {
        if (!this.reachable) {
            return false;
        }
        if (whileNode.isDoWhile()) {
            this.enterDoWhileLoop(whileNode);
        } else {
            this.enterTestFirstLoop(whileNode, null, null, false);
        }
        return false;
    }

    private Map<Symbol, LvarType> getBreakTargetTypes(BreakableNode target) {
        Map<Symbol, LvarType> types = this.localVariableTypes;
        Iterator<LexicalContextNode> it = this.lc.getAllNodes();
        while (it.hasNext()) {
            LexicalContextNode node = it.next();
            if (node instanceof Block) {
                for (Symbol symbol : ((Block)node).getSymbols()) {
                    if (!this.localVariableTypes.containsKey(symbol)) continue;
                    if (types == this.localVariableTypes) {
                        types = LocalVariableTypesCalculator.cloneMap(this.localVariableTypes);
                    }
                    types.remove(symbol);
                }
            }
            if (node != target) continue;
            break;
        }
        return types;
    }

    private LvarType getLocalVariableType(Symbol symbol) {
        LvarType type = this.getLocalVariableTypeOrNull(symbol);
        assert (type != null);
        return type;
    }

    private LvarType getLocalVariableTypeIfBytecode(Symbol symbol) {
        return symbol.isBytecodeLocal() ? this.getLocalVariableType(symbol) : null;
    }

    private LvarType getLocalVariableTypeOrNull(Symbol symbol) {
        return this.localVariableTypes.get(symbol);
    }

    private JumpTarget getOrCreateJumpTarget(Label label) {
        JumpTarget jumpTarget = this.jumpTargets.get(label);
        if (jumpTarget == null) {
            jumpTarget = this.createJumpTarget(label);
        }
        return jumpTarget;
    }

    private void joinOnLabel(Label label) {
        JumpTarget jumpTarget = this.jumpTargets.remove(label);
        if (jumpTarget == null) {
            return;
        }
        assert (!jumpTarget.origins.isEmpty());
        this.reachable = true;
        this.localVariableTypes = LocalVariableTypesCalculator.getUnionTypes(jumpTarget.types, this.localVariableTypes);
        for (JumpOrigin jumpOrigin : jumpTarget.origins) {
            this.setConversion(jumpOrigin.node, jumpOrigin.types, this.localVariableTypes);
        }
    }

    private void jumpToCatchBlock(JoinPredecessor jumpOrigin) {
        Label currentCatchLabel = this.catchLabels.peek();
        if (currentCatchLabel != null) {
            this.jumpToLabel(jumpOrigin, currentCatchLabel);
        }
    }

    private void jumpToLabel(JoinPredecessor jumpOrigin, Label label) {
        this.jumpToLabel(jumpOrigin, label, this.localVariableTypes);
    }

    private void jumpToLabel(JoinPredecessor jumpOrigin, Label label, Map<Symbol, LvarType> types) {
        this.getOrCreateJumpTarget(label).addOrigin(jumpOrigin, types);
    }

    @Override
    public Node leaveBlock(Block block) {
        LabelNode labelNode;
        if (this.lc.isFunctionBody()) {
            if (this.reachable) {
                this.createSyntheticReturn(block);
                assert (!this.reachable);
            }
            this.calculateReturnType();
        }
        boolean cloned = false;
        for (Symbol symbol : block.getSymbols()) {
            if (this.localVariableTypes.containsKey(symbol)) {
                if (!cloned) {
                    this.localVariableTypes = LocalVariableTypesCalculator.cloneMap(this.localVariableTypes);
                    cloned = true;
                }
                this.localVariableTypes.remove(symbol);
            }
            if (!symbol.hasSlot()) continue;
            SymbolConversions conversions = this.symbolConversions.get(symbol);
            if (conversions != null) {
                conversions.calculateTypeLiveness(symbol);
            }
            if (symbol.slotCount() != 0) continue;
            symbol.setNeedsSlot(false);
        }
        if (this.reachable && (labelNode = this.lc.getCurrentBlockLabelNode()) != null) {
            this.jumpToLabel(labelNode, block.getBreakLabel());
        }
        this.leaveBreakable(block);
        return block;
    }

    private void calculateReturnType() {
        if (this.returnType.isUnknown()) {
            this.returnType = Type.OBJECT;
        }
    }

    private void createSyntheticReturn(Block body) {
        FunctionNode functionNode = this.lc.getCurrentFunction();
        long token = functionNode.getToken();
        int finish = functionNode.getFinish();
        List<Statement> statements = body.getStatements();
        int lineNumber = statements.isEmpty() ? functionNode.getLineNumber() : statements.get(statements.size() - 1).getLineNumber();
        IdentNode returnExpr = functionNode.isProgram() ? new IdentNode(token, finish, CompilerConstants.RETURN.symbolName()).setSymbol(LocalVariableTypesCalculator.getCompilerConstantSymbol(functionNode, CompilerConstants.RETURN)) : null;
        this.syntheticReturn = new ReturnNode(lineNumber, token, finish, returnExpr);
        this.syntheticReturn.accept(this);
    }

    private void leaveBreakable(BreakableNode breakable) {
        this.joinOnLabel(breakable.getBreakLabel());
    }

    @Override
    public Node leaveFunctionNode(FunctionNode functionNode) {
        FunctionNode newFunction = functionNode;
        NodeVisitor<LexicalContext> applyChangesVisitor = new NodeVisitor<LexicalContext>(new LexicalContext()){
            private boolean inOuterFunction;
            private final Deque<JoinPredecessor> joinPredecessors;
            {
                this.inOuterFunction = true;
                this.joinPredecessors = new ArrayDeque<JoinPredecessor>();
            }

            @Override
            protected boolean enterDefault(Node node) {
                if (!this.inOuterFunction) {
                    return false;
                }
                if (node instanceof JoinPredecessor) {
                    this.joinPredecessors.push((JoinPredecessor)((Object)node));
                }
                return this.inOuterFunction;
            }

            @Override
            public boolean enterFunctionNode(FunctionNode fn) {
                if (LocalVariableTypesCalculator.this.compiler.isOnDemandCompilation()) {
                    return false;
                }
                this.inOuterFunction = false;
                return true;
            }

            @Override
            public Node leaveBinaryNode(BinaryNode binaryNode) {
                if (binaryNode.isComparison()) {
                    Expression lhs = binaryNode.lhs();
                    Expression rhs = binaryNode.rhs();
                    Type cmpWidest = Type.widest(lhs.getType(), rhs.getType());
                    boolean newRuntimeNode = false;
                    boolean finalized = false;
                    TokenType tt = binaryNode.tokenType();
                    switch (tt) {
                        case EQ_STRICT: 
                        case NE_STRICT: {
                            Expression undefinedNode = LocalVariableTypesCalculator.createIsUndefined(binaryNode, lhs, rhs, tt == TokenType.EQ_STRICT ? RuntimeNode.Request.IS_UNDEFINED : RuntimeNode.Request.IS_NOT_UNDEFINED);
                            if (undefinedNode != binaryNode) {
                                return undefinedNode;
                            }
                            if (lhs.getType().isBoolean() == rhs.getType().isBoolean()) break;
                            newRuntimeNode = true;
                            cmpWidest = Type.OBJECT;
                            finalized = true;
                        }
                    }
                    if (newRuntimeNode || cmpWidest.isObject()) {
                        return new RuntimeNode(binaryNode).setIsFinal(finalized);
                    }
                } else if (binaryNode.isOptimisticUndecidedType()) {
                    return binaryNode.decideType();
                }
                return binaryNode;
            }

            @Override
            protected Node leaveDefault(Node node) {
                if (node instanceof JoinPredecessor) {
                    JoinPredecessor original = this.joinPredecessors.pop();
                    assert (original.getClass() == node.getClass()) : original.getClass().getName() + "!=" + node.getClass().getName();
                    return (Node)((Object)this.setLocalVariableConversion(original, (JoinPredecessor)((Object)node)));
                }
                return node;
            }

            @Override
            public Node leaveBlock(Block block) {
                if (this.inOuterFunction && LocalVariableTypesCalculator.this.syntheticReturn != null && this.lc.isFunctionBody()) {
                    ArrayList<Statement> stmts = new ArrayList<Statement>(block.getStatements());
                    stmts.add((ReturnNode)LocalVariableTypesCalculator.this.syntheticReturn.accept(this));
                    return block.setStatements(this.lc, stmts);
                }
                return super.leaveBlock(block);
            }

            @Override
            public Node leaveFunctionNode(FunctionNode nestedFunctionNode) {
                this.inOuterFunction = true;
                FunctionNode newNestedFunction = (FunctionNode)nestedFunctionNode.accept((NodeVisitor)new LocalVariableTypesCalculator(LocalVariableTypesCalculator.this.compiler));
                this.lc.replace(nestedFunctionNode, newNestedFunction);
                return newNestedFunction;
            }

            @Override
            public Node leaveIdentNode(IdentNode identNode) {
                IdentNode original = (IdentNode)this.joinPredecessors.pop();
                Symbol symbol = identNode.getSymbol();
                if (symbol == null) {
                    assert (identNode.isPropertyName());
                    return identNode;
                }
                if (symbol.hasSlot()) {
                    assert (!symbol.isScope() || symbol.isParam());
                    assert (original.getName().equals(identNode.getName()));
                    LvarType lvarType = (LvarType)((Object)LocalVariableTypesCalculator.this.identifierLvarTypes.remove(original));
                    if (lvarType != null) {
                        return this.setLocalVariableConversion(original, identNode.setType(lvarType.type));
                    }
                    assert (LocalVariableTypesCalculator.this.localVariableConversions.get(original) == null);
                } else assert (LocalVariableTypesCalculator.this.identIsDeadAndHasNoLiveConversions(original));
                return identNode;
            }

            @Override
            public Node leaveLiteralNode(LiteralNode<?> literalNode) {
                return literalNode.initialize(this.lc);
            }

            @Override
            public Node leaveRuntimeNode(RuntimeNode runtimeNode) {
                boolean isEqStrict;
                RuntimeNode.Request request = runtimeNode.getRequest();
                boolean bl = isEqStrict = request == RuntimeNode.Request.EQ_STRICT;
                if (isEqStrict || request == RuntimeNode.Request.NE_STRICT) {
                    return LocalVariableTypesCalculator.createIsUndefined(runtimeNode, runtimeNode.getArgs().get(0), runtimeNode.getArgs().get(1), isEqStrict ? RuntimeNode.Request.IS_UNDEFINED : RuntimeNode.Request.IS_NOT_UNDEFINED);
                }
                return runtimeNode;
            }

            private <T extends JoinPredecessor> T setLocalVariableConversion(JoinPredecessor original, T jp) {
                return (T)jp.setLocalVariableConversion(this.lc, (LocalVariableConversion)LocalVariableTypesCalculator.this.localVariableConversions.get(original));
            }
        };
        newFunction = newFunction.setBody(this.lc, (Block)newFunction.getBody().accept((NodeVisitor<? extends LexicalContext>)applyChangesVisitor));
        newFunction = newFunction.setReturnType(this.lc, this.returnType);
        newFunction = newFunction.setState(this.lc, FunctionNode.CompilationState.LOCAL_VARIABLE_TYPES_CALCULATED);
        newFunction = newFunction.setParameters(this.lc, newFunction.visitParameters((NodeVisitor<? extends LexicalContext>)applyChangesVisitor));
        return newFunction;
    }

    private static Expression createIsUndefined(Expression parent, Expression lhs, Expression rhs, RuntimeNode.Request request) {
        if (LocalVariableTypesCalculator.isUndefinedIdent(lhs) || LocalVariableTypesCalculator.isUndefinedIdent(rhs)) {
            return new RuntimeNode(parent, request, lhs, rhs);
        }
        return parent;
    }

    private static boolean isUndefinedIdent(Expression expr) {
        return expr instanceof IdentNode && "undefined".equals(((IdentNode)expr).getName());
    }

    private boolean identIsDeadAndHasNoLiveConversions(IdentNode identNode) {
        LocalVariableConversion conv = this.localVariableConversions.get(identNode);
        return conv == null || !conv.isLive();
    }

    private void onAssignment(IdentNode identNode, Expression rhs) {
        this.onAssignment(identNode, LocalVariableTypesCalculator.toLvarType(this.getType(rhs)));
    }

    private void onAssignment(IdentNode identNode, LvarType type) {
        LvarType finalType;
        Symbol symbol = identNode.getSymbol();
        assert (symbol != null) : identNode.getName();
        if (!symbol.isBytecodeLocal()) {
            return;
        }
        assert (type != null);
        if (type == LvarType.UNDEFINED && this.getLocalVariableType(symbol) != LvarType.UNDEFINED) {
            finalType = LvarType.OBJECT;
            symbol.setFlag(16384);
        } else {
            finalType = type;
        }
        this.setType(symbol, finalType);
        this.setIdentifierLvarType(identNode, finalType);
        this.jumpToCatchBlock(identNode);
    }

    private void onSelfAssignment(IdentNode identNode, Expression assignment, LvarType typeOnLoad) {
        Symbol symbol = identNode.getSymbol();
        assert (symbol != null) : identNode.getName();
        if (!symbol.isBytecodeLocal()) {
            return;
        }
        LvarType type = LocalVariableTypesCalculator.toLvarType(this.getType(assignment, symbol, typeOnLoad.type));
        assert (type != null && type != LvarType.UNDEFINED && type != LvarType.BOOLEAN);
        this.setType(symbol, type);
        this.jumpToCatchBlock(identNode);
    }

    private void resetJoinPoint(Label label) {
        this.jumpTargets.remove(label);
    }

    private void setCompilerConstantAsObject(FunctionNode functionNode, CompilerConstants cc) {
        Symbol symbol = LocalVariableTypesCalculator.getCompilerConstantSymbol(functionNode, cc);
        this.setType(symbol, LvarType.OBJECT);
        this.symbolIsUsed(symbol);
    }

    private static Symbol getCompilerConstantSymbol(FunctionNode functionNode, CompilerConstants cc) {
        return functionNode.getBody().getExistingSymbol(cc.symbolName());
    }

    private void setConversion(JoinPredecessor node, Map<Symbol, LvarType> branchLvarTypes, Map<Symbol, LvarType> joinLvarTypes) {
        if (node == null) {
            return;
        }
        if (branchLvarTypes.isEmpty() || joinLvarTypes.isEmpty()) {
            this.localVariableConversions.remove(node);
        }
        LocalVariableConversion conversion = null;
        if (node instanceof IdentNode) {
            Symbol symbol = ((IdentNode)node).getSymbol();
            conversion = this.createConversion(symbol, branchLvarTypes.get(symbol), joinLvarTypes, null);
        } else {
            for (Map.Entry<Symbol, LvarType> entry : branchLvarTypes.entrySet()) {
                Symbol symbol = entry.getKey();
                LvarType branchLvarType = entry.getValue();
                conversion = this.createConversion(symbol, branchLvarType, joinLvarTypes, conversion);
            }
        }
        if (conversion != null) {
            this.localVariableConversions.put(node, conversion);
        } else {
            this.localVariableConversions.remove(node);
        }
    }

    private void setIdentifierLvarType(IdentNode identNode, LvarType type) {
        assert (type != null);
        this.identifierLvarTypes.put(identNode, type);
    }

    private void setType(Symbol symbol, LvarType type) {
        if (this.getLocalVariableTypeOrNull(symbol) == type) {
            return;
        }
        assert (symbol.hasSlot());
        assert (!symbol.isGlobal());
        this.localVariableTypes = this.localVariableTypes.isEmpty() ? new IdentityHashMap() : LocalVariableTypesCalculator.cloneMap(this.localVariableTypes);
        this.localVariableTypes.put(symbol, type);
    }

    private void symbolIsUsed(Symbol symbol) {
        LocalVariableTypesCalculator.symbolIsUsed(symbol, this.getLocalVariableType(symbol));
    }

    private Type getType(Expression expr) {
        return expr.getType(this.getSymbolToType());
    }

    private Function<Symbol, Type> getSymbolToType() {
        if (this.symbolToType.isStale()) {
            this.symbolToType = new SymbolToType();
        }
        return this.symbolToType;
    }

    private Type getType(Expression expr, Symbol overriddenSymbol, Type overriddenType) {
        return expr.getType(this.getSymbolToType(overriddenSymbol, overriddenType));
    }

    private Function<Symbol, Type> getSymbolToType(Symbol overriddenSymbol, Type overriddenType) {
        return this.getLocalVariableType(overriddenSymbol).type == overriddenType ? this.getSymbolToType() : new SymbolToTypeOverride(overriddenSymbol, overriddenType);
    }

    static {
        for (LvarType lvarType : LvarType.values()) {
            TO_LVAR_TYPE.put(lvarType.type, lvarType);
        }
    }

    private class SymbolToTypeOverride
    implements Function<Symbol, Type> {
        private final Function<Symbol, Type> originalSymbolToType;
        private final Symbol overriddenSymbol;
        private final Type overriddenType;

        SymbolToTypeOverride(Symbol overriddenSymbol, Type overriddenType) {
            this.originalSymbolToType = LocalVariableTypesCalculator.this.getSymbolToType();
            this.overriddenSymbol = overriddenSymbol;
            this.overriddenType = overriddenType;
        }

        @Override
        public Type apply(Symbol symbol) {
            return symbol == this.overriddenSymbol ? this.overriddenType : this.originalSymbolToType.apply(symbol);
        }
    }

    private class SymbolToType
    implements Function<Symbol, Type> {
        private final Object boundTypes;

        private SymbolToType() {
            this.boundTypes = LocalVariableTypesCalculator.this.localVariableTypes;
        }

        @Override
        public Type apply(Symbol t) {
            return LocalVariableTypesCalculator.this.getLocalVariableType(t).type;
        }

        boolean isStale() {
            return this.boundTypes != LocalVariableTypesCalculator.this.localVariableTypes;
        }
    }

    private static class SymbolConversions {
        private static byte I2L = 1;
        private static byte I2D = (byte)2;
        private static byte I2O = (byte)4;
        private static byte L2D = (byte)8;
        private static byte L2O = (byte)16;
        private static byte D2O = (byte)32;
        private byte conversions;

        private SymbolConversions() {
        }

        void recordConversion(LvarType from, LvarType to) {
            switch (from) {
                case UNDEFINED: {
                    return;
                }
                case INT: 
                case BOOLEAN: {
                    switch (to) {
                        case LONG: {
                            this.recordConversion(I2L);
                            return;
                        }
                        case DOUBLE: {
                            this.recordConversion(I2D);
                            return;
                        }
                        case OBJECT: {
                            this.recordConversion(I2O);
                            return;
                        }
                    }
                    SymbolConversions.illegalConversion(from, to);
                    return;
                }
                case LONG: {
                    switch (to) {
                        case DOUBLE: {
                            this.recordConversion(L2D);
                            return;
                        }
                        case OBJECT: {
                            this.recordConversion(L2O);
                            return;
                        }
                    }
                    SymbolConversions.illegalConversion(from, to);
                    return;
                }
                case DOUBLE: {
                    if (to == LvarType.OBJECT) {
                        this.recordConversion(D2O);
                    }
                    return;
                }
            }
            SymbolConversions.illegalConversion(from, to);
        }

        private static void illegalConversion(LvarType from, LvarType to) {
            throw new AssertionError((Object)("Invalid conversion from " + (Object)((Object)from) + " to " + (Object)((Object)to)));
        }

        void recordConversion(byte convFlag) {
            this.conversions = (byte)(this.conversions | convFlag);
        }

        boolean hasConversion(byte convFlag) {
            return (this.conversions & convFlag) != 0;
        }

        void calculateTypeLiveness(Symbol symbol) {
            if (symbol.hasSlotFor(Type.OBJECT)) {
                if (this.hasConversion(D2O)) {
                    symbol.setHasSlotFor(Type.NUMBER);
                }
                if (this.hasConversion(L2O)) {
                    symbol.setHasSlotFor(Type.LONG);
                }
                if (this.hasConversion(I2O)) {
                    symbol.setHasSlotFor(Type.INT);
                }
            }
            if (symbol.hasSlotFor(Type.NUMBER)) {
                if (this.hasConversion(L2D)) {
                    symbol.setHasSlotFor(Type.LONG);
                }
                if (this.hasConversion(I2D)) {
                    symbol.setHasSlotFor(Type.INT);
                }
            }
            if (symbol.hasSlotFor(Type.LONG) && this.hasConversion(I2L)) {
                symbol.setHasSlotFor(Type.INT);
            }
        }
    }

    private static enum LvarType {
        UNDEFINED(Type.UNDEFINED),
        BOOLEAN(Type.BOOLEAN),
        INT(Type.INT),
        LONG(Type.LONG),
        DOUBLE(Type.NUMBER),
        OBJECT(Type.OBJECT);

        private final Type type;

        private LvarType(Type type) {
            this.type = type;
        }
    }

    private static class JumpTarget {
        private final List<JumpOrigin> origins = new LinkedList<JumpOrigin>();
        private Map<Symbol, LvarType> types = Collections.emptyMap();

        private JumpTarget() {
        }

        void addOrigin(JoinPredecessor originNode, Map<Symbol, LvarType> originTypes) {
            this.origins.add(new JumpOrigin(originNode, originTypes));
            this.types = LocalVariableTypesCalculator.getUnionTypes(this.types, originTypes);
        }
    }

    private static class JumpOrigin {
        final JoinPredecessor node;
        final Map<Symbol, LvarType> types;

        JumpOrigin(JoinPredecessor node, Map<Symbol, LvarType> types) {
            this.node = node;
            this.types = types;
        }
    }
}

