/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;

public class PropertyListeners {
    private Map<String, WeakPropertyMapSet> listeners;
    private static int listenersAdded;
    private static int listenersRemoved;

    PropertyListeners(PropertyListeners listener) {
        if (listener != null && listener.listeners != null) {
            this.listeners = new WeakHashMap<String, WeakPropertyMapSet>(listener.listeners);
        }
    }

    public static int getListenersAdded() {
        return listenersAdded;
    }

    public static int getListenersRemoved() {
        return listenersRemoved;
    }

    public static int getListenerCount(ScriptObject obj) {
        PropertyListeners propertyListeners = obj.getMap().getListeners();
        if (propertyListeners != null) {
            return propertyListeners.listeners == null ? 0 : propertyListeners.listeners.size();
        }
        return 0;
    }

    public static PropertyListeners addListener(PropertyListeners listeners, String key, PropertyMap propertyMap) {
        if (listeners == null || !listeners.containsListener(key, propertyMap)) {
            PropertyListeners newListeners = new PropertyListeners(listeners);
            newListeners.addListener(key, propertyMap);
            return newListeners;
        }
        return listeners;
    }

    synchronized boolean containsListener(String key, PropertyMap propertyMap) {
        if (this.listeners == null) {
            return false;
        }
        WeakPropertyMapSet set = this.listeners.get(key);
        return set != null && set.contains(propertyMap);
    }

    final synchronized void addListener(String key, PropertyMap propertyMap) {
        WeakPropertyMapSet set;
        if (Context.DEBUG) {
            ++listenersAdded;
        }
        if (this.listeners == null) {
            this.listeners = new WeakHashMap<String, WeakPropertyMapSet>();
        }
        if ((set = this.listeners.get(key)) == null) {
            set = new WeakPropertyMapSet();
            this.listeners.put(key, set);
        }
        if (!set.contains(propertyMap)) {
            set.add(propertyMap);
        }
    }

    public synchronized void propertyAdded(Property prop) {
        WeakPropertyMapSet set;
        if (this.listeners != null && (set = this.listeners.get(prop.getKey())) != null) {
            for (PropertyMap propertyMap : set.elements()) {
                propertyMap.propertyAdded(prop);
            }
            this.listeners.remove(prop.getKey());
        }
    }

    public synchronized void propertyDeleted(Property prop) {
        WeakPropertyMapSet set;
        if (this.listeners != null && (set = this.listeners.get(prop.getKey())) != null) {
            for (PropertyMap propertyMap : set.elements()) {
                propertyMap.propertyDeleted(prop);
            }
            this.listeners.remove(prop.getKey());
        }
    }

    public synchronized void propertyModified(Property oldProp, Property newProp) {
        WeakPropertyMapSet set;
        if (this.listeners != null && (set = this.listeners.get(oldProp.getKey())) != null) {
            for (PropertyMap propertyMap : set.elements()) {
                propertyMap.propertyModified(oldProp, newProp);
            }
            this.listeners.remove(oldProp.getKey());
        }
    }

    public synchronized void protoChanged() {
        if (this.listeners != null) {
            for (WeakPropertyMapSet set : this.listeners.values()) {
                for (PropertyMap propertyMap : set.elements()) {
                    propertyMap.protoChanged();
                }
            }
            this.listeners.clear();
        }
    }

    private static class WeakPropertyMapSet {
        private final WeakHashMap<PropertyMap, Boolean> map = new WeakHashMap();

        private WeakPropertyMapSet() {
        }

        void add(PropertyMap propertyMap) {
            this.map.put(propertyMap, Boolean.TRUE);
        }

        boolean contains(PropertyMap propertyMap) {
            return this.map.containsKey(propertyMap);
        }

        Set<PropertyMap> elements() {
            return this.map.keySet();
        }
    }
}

