/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.deploy.Environment;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.javaws.MacOSXShortcutInfo;
import com.sun.javaws.jnl.LaunchDesc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class MacOSXShortcutUtil {
    private static final String RUNTIME_BUNDLE = "/Library/Internet Plug-Ins/JavaAppletPlugin.plugin";
    private static final String PLIST_DTD = "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">";
    private static final String PLIST_TAG = "plist";
    private static final String PLIST_VERSION_ATTRIBUTE = "version";
    private static final String DICT_TAG = "dict";
    private static final String KEY_TAG = "key";
    private static final String ARRAY_TAG = "array";
    private static final String STRING_TAG = "string";

    MacOSXShortcutUtil() {
    }

    public static void createBundle(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, File file, List list) throws IOException {
        MacOSXShortcutInfo macOSXShortcutInfo = new MacOSXShortcutInfo(launchDesc, localApplicationProperties, file, list);
        File file2 = macOSXShortcutInfo.getBundleDirectory();
        file2.mkdir();
        File file3 = new File(file2, "Contents");
        file3.mkdir();
        File file4 = new File(file3, "MacOS");
        file4.mkdir();
        File file5 = new File(file3, "Resources");
        file5.mkdir();
        File file6 = new File(file3, "Info.plist");
        file6.createNewFile();
        MacOSXShortcutUtil.writeInfoPlist(file6, macOSXShortcutInfo);
        File file7 = new File(file3, "PkgInfo");
        file7.createNewFile();
        MacOSXShortcutUtil.writePkgInfo(file7, macOSXShortcutInfo);
        String string = Environment.getJavaHome() + "/lib/shortcuts/JavaWSApplicationStub";
        File file8 = new File(string);
        File file9 = new File(file4, macOSXShortcutInfo.getBundleExecutable());
        MacOSXShortcutUtil.copy(file8.getAbsolutePath(), file9.getAbsolutePath());
        file9.setExecutable(true);
        String string2 = macOSXShortcutInfo.getBundleAppIconPath();
        File file10 = new File(file5, macOSXShortcutInfo.getBundleAppIconName());
        MacOSXShortcutUtil.copy(string2, file10.getAbsolutePath());
        int n = macOSXShortcutInfo.getBundleDocCount();
        for (int i = 0; i < n; ++i) {
            String string3 = macOSXShortcutInfo.getBundleDocIconPath(i);
            File file11 = new File(file5, macOSXShortcutInfo.getBundleDocIconName(i));
            MacOSXShortcutUtil.copy(string3, file11.getAbsolutePath());
        }
    }

    private static void writeInfoPlist(File file, MacOSXShortcutInfo macOSXShortcutInfo) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        try {
            XMLStreamWriter xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter(bufferedWriter);
            xMLStreamWriter.writeStartDocument();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeDTD(PLIST_DTD);
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement(PLIST_TAG);
            xMLStreamWriter.writeAttribute(PLIST_VERSION_ATTRIBUTE, "1.0");
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeStartElement(DICT_TAG);
            xMLStreamWriter.writeCharacters("\n");
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleExecutable", macOSXShortcutInfo.getBundleExecutable());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleGetInfoString", macOSXShortcutInfo.getBundleGetInfoString());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleIconFile", macOSXShortcutInfo.getBundleAppIconName());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleIdentifier", macOSXShortcutInfo.getBundleIdentifier());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleName", macOSXShortcutInfo.getBundleName());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundlePackageType", macOSXShortcutInfo.getBundlePackageType());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "CFBundleSignature", macOSXShortcutInfo.getBundleSignature());
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "NSPrincipalClass", "NSApplication");
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 1, "LSUIElement", "1");
            MacOSXShortcutUtil.writeDocumentTypes(xMLStreamWriter, macOSXShortcutInfo);
            MacOSXShortcutUtil.writeKey(xMLStreamWriter, 1, "WebStartArgs");
            xMLStreamWriter.writeCharacters("\t");
            xMLStreamWriter.writeStartElement(ARRAY_TAG);
            xMLStreamWriter.writeCharacters("\n");
            String[] stringArray = macOSXShortcutInfo.getLaunchArgs();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                MacOSXShortcutUtil.writeString(xMLStreamWriter, 2, stringArray[i]);
            }
            xMLStreamWriter.writeCharacters("\t");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.writeCharacters("\n");
            ((Writer)bufferedWriter).flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new IOException(xMLStreamException);
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    private static void writePkgInfo(File file, MacOSXShortcutInfo macOSXShortcutInfo) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        try {
            bufferedWriter.write(macOSXShortcutInfo.getBundlePackageType() + macOSXShortcutInfo.getBundleSignature());
            ((Writer)bufferedWriter).flush();
        }
        finally {
            ((Writer)bufferedWriter).close();
        }
    }

    private static void writeDocumentTypes(XMLStreamWriter xMLStreamWriter, MacOSXShortcutInfo macOSXShortcutInfo) throws XMLStreamException {
        int n = macOSXShortcutInfo.getBundleDocCount();
        if (n == 0) {
            return;
        }
        MacOSXShortcutUtil.writeKey(xMLStreamWriter, 1, "CFBundleDocumentTypes");
        xMLStreamWriter.writeCharacters("\t");
        xMLStreamWriter.writeStartElement(ARRAY_TAG);
        xMLStreamWriter.writeCharacters("\n");
        for (int i = 0; i < n; ++i) {
            String string;
            xMLStreamWriter.writeCharacters("\t\t");
            xMLStreamWriter.writeStartElement(DICT_TAG);
            xMLStreamWriter.writeCharacters("\n");
            MacOSXShortcutUtil.writeKey(xMLStreamWriter, 3, "CFBundleTypeExtensions");
            xMLStreamWriter.writeCharacters("\t\t\t");
            xMLStreamWriter.writeStartElement(ARRAY_TAG);
            xMLStreamWriter.writeCharacters("\n");
            List list = macOSXShortcutInfo.getBundleExtensions(i);
            for (int j = 0; j < list.size(); ++j) {
                string = (String)list.get(j);
                MacOSXShortcutUtil.writeString(xMLStreamWriter, 4, string.substring(1));
            }
            xMLStreamWriter.writeCharacters("\t\t\t");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            MacOSXShortcutUtil.writeKey(xMLStreamWriter, 3, "CFBundleTypeMIMETypes");
            xMLStreamWriter.writeCharacters("\t\t\t");
            xMLStreamWriter.writeStartElement(ARRAY_TAG);
            xMLStreamWriter.writeCharacters("\n");
            List list2 = macOSXShortcutInfo.getBundleMIMETypes(i);
            for (int j = 0; j < list2.size(); ++j) {
                MacOSXShortcutUtil.writeString(xMLStreamWriter, 4, (String)list2.get(j));
            }
            xMLStreamWriter.writeCharacters("\t\t\t");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
            string = macOSXShortcutInfo.getBundleDocIconName(i);
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 3, "CFBundleTypeIconFile", string);
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 3, "JWSIconPath", macOSXShortcutInfo.getBundleDocIconPath(i));
            String string2 = macOSXShortcutInfo.getBundleDocName(i);
            if (string2 != null) {
                MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 3, "CFBundleTypeName", string2);
            }
            MacOSXShortcutUtil.writeProperty(xMLStreamWriter, 3, "CFBundleTypeRole", "Editor");
            xMLStreamWriter.writeCharacters("\t\t");
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeCharacters("\n");
        }
        xMLStreamWriter.writeCharacters("\t");
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeCharacters("\n");
    }

    private static void writeProperty(XMLStreamWriter xMLStreamWriter, int n, String string, String string2) throws XMLStreamException {
        MacOSXShortcutUtil.writeKey(xMLStreamWriter, n, string);
        MacOSXShortcutUtil.writeString(xMLStreamWriter, n, string2);
    }

    private static void writeKey(XMLStreamWriter xMLStreamWriter, int n, String string) throws XMLStreamException {
        for (int i = 0; i < n; ++i) {
            xMLStreamWriter.writeCharacters("\t");
        }
        xMLStreamWriter.writeStartElement(KEY_TAG);
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeCharacters("\n");
    }

    private static void writeString(XMLStreamWriter xMLStreamWriter, int n, String string) throws XMLStreamException {
        for (int i = 0; i < n; ++i) {
            xMLStreamWriter.writeCharacters("\t");
        }
        xMLStreamWriter.writeStartElement(STRING_TAG);
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeCharacters("\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String string, String string2) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        int n = -1;
        int n2 = (int)new File(string).length();
        byte[] byArray = new byte[n2];
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            bufferedInputStream.read(byArray, 0, n2);
            ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            bufferedInputStream.close();
            filterOutputStream.close();
        }
    }
}

