/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.behavior.RatingBehavior;
import java.util.ArrayList;
import java.util.Collections;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.Rating;

public class RatingSkin
extends BehaviorSkinBase<Rating, RatingBehavior> {
    private static final String STRONG = "strong";
    private boolean updateOnHover;
    private boolean partialRating;
    private Pane backgroundContainer;
    private Pane foregroundContainer;
    private double rating = -1.0;
    private Rectangle forgroundClipRect;
    private Point2D lastMouseLocation = new Point2D(0.0, 0.0);
    private final EventHandler<MouseEvent> mouseMoveHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            double newRating;
            RatingSkin.this.lastMouseLocation = new Point2D(event.getSceneX(), event.getSceneY());
            double d = newRating = RatingSkin.this.partialRating || RatingSkin.this.updateOnHover ? RatingSkin.this.calculateRating() : -1.0;
            if (RatingSkin.this.partialRating && RatingSkin.this.updateOnHover) {
                RatingSkin.this.updateClip();
            }
            if (RatingSkin.this.updateOnHover && newRating > -1.0) {
                RatingSkin.this.updateRating(newRating);
            }
        }
    };
    private final EventHandler<MouseEvent> mouseClickHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (RatingSkin.this.updateOnHover) {
                return;
            }
            if (RatingSkin.this.partialRating) {
                RatingSkin.this.updateClip();
            }
            RatingSkin.this.updateRating(RatingSkin.this.calculateRating());
        }
    };

    public RatingSkin(Rating control) {
        super((Control)control, (BehaviorBase)new RatingBehavior(control));
        this.updateOnHover = control.isUpdateOnHover();
        this.partialRating = control.isPartialRating();
        this.recreateButtons();
        this.updateRating(((Rating)this.getSkinnable()).getRating());
        this.registerChangeListener((ObservableValue)control.ratingProperty(), "RATING");
        this.registerChangeListener((ObservableValue)control.maxProperty(), "MAX");
        this.registerChangeListener((ObservableValue)control.orientationProperty(), "ORIENTATION");
        this.registerChangeListener((ObservableValue)control.updateOnHoverProperty(), "UPDATE_ON_HOVER");
        this.registerChangeListener((ObservableValue)control.partialRatingProperty(), "PARTIAL_RATING");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (p == "RATING") {
            this.updateRating();
        } else if (p == "MAX") {
            this.recreateButtons();
        } else if (p == "ORIENTATION") {
            this.recreateButtons();
        } else if (p == "PARTIAL_RATING") {
            this.partialRating = ((Rating)this.getSkinnable()).isPartialRating();
            this.recreateButtons();
        } else if (p == "UPDATE_ON_HOVER") {
            this.updateOnHover = ((Rating)this.getSkinnable()).isUpdateOnHover();
            this.recreateButtons();
        }
    }

    private void recreateButtons() {
        this.backgroundContainer = null;
        this.foregroundContainer = null;
        this.backgroundContainer = this.isVertical() ? new VBox() : new HBox();
        this.backgroundContainer.getStyleClass().add((Object)"container");
        this.getChildren().setAll((Object[])new Node[]{this.backgroundContainer});
        if (this.updateOnHover || this.partialRating) {
            this.foregroundContainer = this.isVertical() ? new VBox() : new HBox();
            this.foregroundContainer.getStyleClass().add((Object)"container");
            this.foregroundContainer.setMouseTransparent(true);
            this.getChildren().add((Object)this.foregroundContainer);
            this.forgroundClipRect = new Rectangle();
            this.foregroundContainer.setClip((Node)this.forgroundClipRect);
        }
        for (int index = 0; index <= ((Rating)this.getSkinnable()).getMax(); ++index) {
            Node backgroundNode = this.createButton();
            if (index <= 0) continue;
            if (this.isVertical()) {
                this.backgroundContainer.getChildren().add(0, (Object)backgroundNode);
            } else {
                this.backgroundContainer.getChildren().add((Object)backgroundNode);
            }
            if (!this.partialRating) continue;
            Node foregroundNode = this.createButton();
            foregroundNode.getStyleClass().add((Object)STRONG);
            foregroundNode.setMouseTransparent(true);
            if (this.isVertical()) {
                this.foregroundContainer.getChildren().add(0, (Object)foregroundNode);
                continue;
            }
            this.foregroundContainer.getChildren().add((Object)foregroundNode);
        }
        this.updateRating();
    }

    private double calculateRating() {
        Point2D b = this.backgroundContainer.sceneToLocal(this.lastMouseLocation.getX(), this.lastMouseLocation.getY());
        double x = b.getX();
        double y = b.getY();
        Rating control = (Rating)this.getSkinnable();
        int max = control.getMax();
        double w = control.getWidth() - (this.snappedLeftInset() + this.snappedRightInset());
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        double newRating = -1.0;
        newRating = this.isVertical() ? (h - y) / h * (double)max : x / w * (double)max;
        if (!this.partialRating) {
            newRating = Utils.clamp((double)1.0, (double)Math.ceil(newRating), (double)control.getMax());
        }
        return newRating;
    }

    private void updateClip() {
        Point2D b = this.backgroundContainer.sceneToLocal(this.lastMouseLocation.getX(), this.lastMouseLocation.getY());
        Rating control = (Rating)this.getSkinnable();
        double x = b.getX();
        double y = b.getY();
        double h = control.getHeight() - (this.snappedTopInset() + this.snappedBottomInset());
        if (this.isVertical()) {
            this.forgroundClipRect.relocate(0.0, y);
            this.forgroundClipRect.setWidth(control.getWidth());
            this.forgroundClipRect.setHeight(h - y);
        } else {
            this.forgroundClipRect.setWidth(x);
            this.forgroundClipRect.setHeight(control.getHeight());
        }
    }

    private Node createButton() {
        Region btn = new Region();
        btn.getStyleClass().add((Object)"button");
        btn.setOnMouseMoved(this.mouseMoveHandler);
        btn.setOnMouseClicked(this.mouseClickHandler);
        return btn;
    }

    private void updateRating() {
        this.updateRating(((Rating)this.getSkinnable()).getRating());
    }

    private void updateRating(double newRating) {
        if (newRating == this.rating) {
            return;
        }
        this.rating = Utils.clamp((double)0.0, (double)newRating, (double)((Rating)this.getSkinnable()).getMax());
        if (!((Rating)this.getSkinnable()).ratingProperty().isBound()) {
            ((Rating)this.getSkinnable()).setRating(this.rating);
        }
        if (!this.partialRating) {
            int max = ((Rating)this.getSkinnable()).getMax();
            ArrayList buttons = new ArrayList(this.backgroundContainer.getChildren());
            if (this.isVertical()) {
                Collections.reverse(buttons);
            }
            for (int i = 0; i < max; ++i) {
                Node button = (Node)buttons.get(i);
                ObservableList styleClass = button.getStyleClass();
                boolean containsStrong = styleClass.contains(STRONG);
                if ((double)i < this.rating) {
                    if (containsStrong) continue;
                    styleClass.add(STRONG);
                    continue;
                }
                if (!containsStrong) continue;
                styleClass.remove(STRONG);
            }
        }
    }

    private boolean isVertical() {
        return ((Rating)this.getSkinnable()).getOrientation() == Orientation.VERTICAL;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }

    static {
        StyleManager.getInstance().addUserAgentStylesheet(Rating.class.getResource("rating.css").toExternalForm());
    }
}

