/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.TableColumnHeader;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import java.util.Stack;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalPicker
extends StackPane {
    private static final String PICKER_INDEX = "PickerIndex";
    private final HorizontalHeader horizontalHeader;
    private final SpreadsheetView spv;
    private final Stack<Label> pickerPile;
    private final Stack<Label> pickerUsed;
    private final InnerHorizontalPicker innerPicker = new InnerHorizontalPicker();
    private final EventHandler<MouseEvent> pickerMouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            Label picker = (Label)mouseEvent.getSource();
            HorizontalPicker.this.spv.getColumnPickerCallback().call((Object)((Integer)picker.getProperties().get((Object)HorizontalPicker.PICKER_INDEX)));
        }
    };

    public HorizontalPicker(HorizontalHeader horizontalHeader, SpreadsheetView spv) {
        this.horizontalHeader = horizontalHeader;
        this.spv = spv;
        this.pickerPile = new Stack();
        this.pickerUsed = new Stack();
        Rectangle clip = new Rectangle();
        clip.setSmooth(true);
        clip.setHeight(16.0);
        clip.widthProperty().bind((ObservableValue)horizontalHeader.widthProperty());
        this.setClip((Node)clip);
        this.getChildren().add((Object)this.innerPicker);
        horizontalHeader.getRootHeader().getColumnHeaders().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                HorizontalPicker.this.innerPicker.requestLayout();
            }
        });
    }

    protected void layoutChildren() {
        this.innerPicker.relocate(this.horizontalHeader.getRootHeader().getLayoutX(), this.snappedTopInset());
    }

    public void updateScrollX() {
        this.requestLayout();
    }

    private Label getPicker(int columnNumber) {
        Label picker;
        if (this.pickerPile.isEmpty()) {
            picker = new Label();
            picker.getStyleClass().add((Object)"picker-label");
            picker.setOnMouseClicked(this.pickerMouseEvent);
        } else {
            picker = this.pickerPile.pop();
        }
        this.pickerUsed.push(picker);
        picker.getProperties().put((Object)PICKER_INDEX, (Object)columnNumber);
        return picker;
    }

    private class InnerHorizontalPicker
    extends Region {
        private InnerHorizontalPicker() {
        }

        protected void layoutChildren() {
            HorizontalPicker.this.pickerPile.addAll(HorizontalPicker.this.pickerUsed.subList(0, HorizontalPicker.this.pickerUsed.size()));
            HorizontalPicker.this.pickerUsed.clear();
            this.getChildren().clear();
            double x = 0.0;
            for (int index = 0; index < HorizontalPicker.this.horizontalHeader.getRootHeader().getColumnHeaders().size(); ++index) {
                TableColumnHeader column = (TableColumnHeader)HorizontalPicker.this.horizontalHeader.getRootHeader().getColumnHeaders().get(index);
                if (HorizontalPicker.this.spv.getColumnPickers().contains((Object)index)) {
                    Label label = HorizontalPicker.this.getPicker(index);
                    label.resize(column.getWidth(), 16.0);
                    label.setLayoutX(x);
                    this.getChildren().add((Object)label);
                }
                x += column.getWidth();
            }
        }
    }
}

