/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.PropertySheetSkin;
import java.util.Optional;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Skin;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;
import org.controlsfx.property.editor.DefaultPropertyEditorFactory;
import org.controlsfx.property.editor.PropertyEditor;

public class PropertySheet
extends ControlsFXControl {
    private final ObservableList<Item> items;
    private final SimpleObjectProperty<Mode> modeProperty = new SimpleObjectProperty((Object)this, "mode", (Object)Mode.NAME);
    private final SimpleObjectProperty<Callback<Item, PropertyEditor<?>>> propertyEditorFactory = new SimpleObjectProperty((Object)this, "propertyEditor", (Object)new DefaultPropertyEditorFactory());
    private final SimpleBooleanProperty modeSwitcherVisible = new SimpleBooleanProperty((Object)this, "modeSwitcherVisible", true);
    private final SimpleBooleanProperty searchBoxVisible = new SimpleBooleanProperty((Object)this, "searchBoxVisible", true);
    private final SimpleStringProperty titleFilterProperty = new SimpleStringProperty((Object)this, "titleFilter", "");
    private static final String DEFAULT_STYLE_CLASS = "property-sheet";

    public PropertySheet() {
        this(null);
    }

    public PropertySheet(ObservableList<Item> items) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.items = items == null ? FXCollections.observableArrayList() : items;
    }

    public ObservableList<Item> getItems() {
        return this.items;
    }

    protected Skin<?> createDefaultSkin() {
        return new PropertySheetSkin(this);
    }

    public final SimpleObjectProperty<Mode> modeProperty() {
        return this.modeProperty;
    }

    public final Mode getMode() {
        return (Mode)((Object)this.modeProperty.get());
    }

    public final void setMode(Mode mode) {
        this.modeProperty.set((Object)mode);
    }

    public final SimpleObjectProperty<Callback<Item, PropertyEditor<?>>> propertyEditorFactory() {
        return this.propertyEditorFactory;
    }

    public final Callback<Item, PropertyEditor<?>> getPropertyEditorFactory() {
        return (Callback)this.propertyEditorFactory.get();
    }

    public final void setPropertyEditorFactory(Callback<Item, PropertyEditor<?>> factory) {
        this.propertyEditorFactory.set((Object)(factory == null ? new DefaultPropertyEditorFactory() : factory));
    }

    public final SimpleBooleanProperty modeSwitcherVisibleProperty() {
        return this.modeSwitcherVisible;
    }

    public final boolean isModeSwitcherVisible() {
        return this.modeSwitcherVisible.get();
    }

    public final void setModeSwitcherVisible(boolean visible) {
        this.modeSwitcherVisible.set(visible);
    }

    public final SimpleBooleanProperty searchBoxVisibleProperty() {
        return this.searchBoxVisible;
    }

    public final boolean isSearchBoxVisible() {
        return this.searchBoxVisible.get();
    }

    public final void setSearchBoxVisible(boolean visible) {
        this.searchBoxVisible.set(visible);
    }

    public final SimpleStringProperty titleFilter() {
        return this.titleFilterProperty;
    }

    public final String getTitleFilter() {
        return this.titleFilterProperty.get();
    }

    public final void setTitleFilter(String filter) {
        this.titleFilterProperty.set(filter);
    }

    public static interface Item {
        public Class<?> getType();

        public String getCategory();

        public String getName();

        public String getDescription();

        public Object getValue();

        public void setValue(Object var1);

        default public Optional<Class<? extends PropertyEditor<?>>> getPropertyEditorClass() {
            return Optional.empty();
        }

        default public boolean isEditable() {
            return true;
        }
    }

    public static enum Mode {
        NAME,
        CATEGORY;

    }
}

