/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.stage.Window;
import javafx.util.Duration;
import org.controlsfx.tools.Platform;

@Deprecated
abstract class FXDialog {
    protected static final URL DIALOGS_CSS_URL = FXDialog.class.getResource("old-dialogs.css");
    protected static final int HEADER_HEIGHT = 28;
    public static final List<String> COMMON_STYLE_CLASSES = Collections.unmodifiableList(Arrays.asList("root", "dialog", "decorated-root", "windows", "heavyweight", "lightweight"));
    protected BorderPane root;
    protected HBox windowBtns;
    protected Button closeButton;
    protected Button minButton;
    protected Button maxButton;
    protected Rectangle resizeCorner;
    protected Label titleLabel;
    protected ToolBar dialogTitleBar;
    protected double mouseDragDeltaX = 0.0;
    protected double mouseDragDeltaY = 0.0;
    protected StackPane lightweightDialog;
    protected boolean modal = false;
    private double initialX = 0.0;
    private final DoubleProperty shakeProperty = new SimpleDoubleProperty(this, "shakeProperty", 0.0){

        protected void invalidated() {
            FXDialog.this.setX(FXDialog.this.initialX + FXDialog.this.shakeProperty.get() * 25.0);
        }
    };
    private boolean updateLock = false;
    protected static final PseudoClass ACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"active");

    protected FXDialog() {
    }

    protected final void init(String title) {
        this.titleProperty().set((Object)title);
        this.root = new BorderPane();
        this.lightweightDialog = new StackPane(){

            protected void layoutChildren() {
                super.layoutChildren();
                if (FXDialog.this.resizeCorner != null) {
                    FXDialog.this.resizeCorner.relocate(this.getWidth() - FXDialog.this.resizeCorner.getWidth(), this.getHeight() - FXDialog.this.resizeCorner.getHeight());
                }
            }
        };
        this.lightweightDialog.getChildren().add((Object)this.root);
        this.lightweightDialog.getStyleClass().addAll((Object[])new String[]{"dialog", "decorated-root", Platform.getCurrent().getPlatformId()});
        this.resizeCorner = new Rectangle(10.0, 10.0);
        this.resizeCorner.getStyleClass().add((Object)"window-resize-corner");
        this.resizeCorner.setManaged(false);
        this.lightweightDialog.getChildren().add((Object)this.resizeCorner);
        this.dialogTitleBar = new ToolBar();
        this.dialogTitleBar.getStyleClass().add((Object)"window-header");
        this.dialogTitleBar.setPrefHeight(28.0);
        this.dialogTitleBar.setMinHeight(28.0);
        this.dialogTitleBar.setMaxHeight(28.0);
        this.titleLabel = new Label();
        this.titleLabel.setMaxHeight(Double.MAX_VALUE);
        this.titleLabel.getStyleClass().add((Object)"window-title");
        this.titleLabel.setText((String)this.titleProperty().get());
        this.titleProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable valueModel) {
                FXDialog.this.titleLabel.setText((String)FXDialog.this.titleProperty().get());
            }
        });
        Region spacer = new Region();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        this.closeButton = new WindowButton("close");
        this.closeButton.setFocusTraversable(false);
        this.closeButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXDialog.this.hide();
            }
        });
        this.minButton = new WindowButton("minimize");
        this.minButton.setFocusTraversable(false);
        this.minButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FXDialog.this.setIconified(FXDialog.this.isIconified());
            }
        });
        this.maxButton = new WindowButton("maximize");
        this.maxButton.setFocusTraversable(false);
        this.windowBtns = new HBox(3.0);
        this.windowBtns.getStyleClass().add((Object)"window-buttons");
        this.windowBtns.getChildren().addAll((Object[])new Node[]{this.minButton, this.maxButton, this.closeButton});
        this.dialogTitleBar.getItems().addAll((Object[])new Node[]{this.titleLabel, spacer, this.windowBtns});
        this.root.setTop((Node)this.dialogTitleBar);
        this.getStyleClass().addListener(c -> {
            while (c.next()) {
                this.updateStageStyle(new ArrayList(c.getRemoved()), new ArrayList(c.getAddedSubList()));
            }
        });
        this.resizableProperty().addListener(valueModel -> this.updateResizable());
        this.updateResizable();
        this.focusedProperty().addListener(valueModel -> {
            boolean active = ((ReadOnlyBooleanProperty)valueModel).get();
            this.lightweightDialog.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, active);
        });
        this.updateStageStyle(null, (List<? extends String>)this.getStyleClass());
    }

    private void updateResizable() {
        this.resizeCorner.setVisible(this.resizableProperty().get());
        if (this.maxButton != null) {
            this.maxButton.setVisible(this.resizableProperty().get());
            if (this.resizableProperty().get()) {
                if (!this.windowBtns.getChildren().contains((Object)this.maxButton)) {
                    this.windowBtns.getChildren().add(1, (Object)this.maxButton);
                }
            } else {
                this.windowBtns.getChildren().remove((Object)this.maxButton);
            }
        }
    }

    public void shake() {
        Timeline timeline = new Timeline();
        timeline.setCycleCount(2);
        KeyValue keyValue0 = new KeyValue((WritableValue)this.shakeProperty, (Object)0.0, Interpolator.EASE_BOTH);
        KeyValue keyValue1 = new KeyValue((WritableValue)this.shakeProperty, (Object)-1.0, Interpolator.EASE_BOTH);
        KeyValue keyValue2 = new KeyValue((WritableValue)this.shakeProperty, (Object)1.0, Interpolator.EASE_BOTH);
        this.initialX = this.getX();
        double sectionDuration = 50.0;
        timeline.getKeyFrames().clear();
        timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue0}), new KeyFrame(Duration.millis((double)50.0), new KeyValue[]{keyValue1}), new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{keyValue2}), new KeyFrame(Duration.millis((double)200.0), new KeyValue[]{keyValue0})});
        timeline.play();
    }

    public ObservableList<String> getStyleClass() {
        return this.lightweightDialog.getStyleClass();
    }

    protected boolean isNativeStyleClassSet() {
        return this.getStyleClass().contains((Object)"native");
    }

    protected boolean isCrossPlatformStyleClassSet() {
        return this.getStyleClass().contains((Object)"cross-platform");
    }

    protected boolean isUndecoratedStyleClassSet() {
        return this.getStyleClass().contains((Object)"undecorated");
    }

    protected void setCrossPlatformStyleEnabled(boolean enabled) {
        this.dialogTitleBar.setVisible(enabled);
        this.dialogTitleBar.setManaged(enabled);
    }

    protected void setNativeStyleEnabled(boolean enabled) {
        this.dialogTitleBar.setVisible(false);
        this.dialogTitleBar.setManaged(false);
    }

    protected void setUndecoratedStyleEnabled(boolean enabled) {
        this.dialogTitleBar.setVisible(false);
        this.dialogTitleBar.setManaged(false);
    }

    public abstract void show();

    public abstract void hide();

    public abstract Window getWindow();

    public abstract void sizeToScene();

    public abstract double getX();

    public abstract void setX(double var1);

    abstract BooleanProperty resizableProperty();

    abstract ReadOnlyBooleanProperty focusedProperty();

    abstract StringProperty titleProperty();

    public abstract void setContentPane(Pane var1);

    public abstract Node getRoot();

    public abstract ObservableList<String> getStylesheets();

    abstract ReadOnlyDoubleProperty widthProperty();

    abstract ReadOnlyDoubleProperty heightProperty();

    abstract void setIconifiable(boolean var1);

    abstract void setIconified(boolean var1);

    abstract boolean isIconified();

    abstract void setClosable(boolean var1);

    abstract void setModal(boolean var1);

    abstract boolean isModal();

    abstract void setEffect(Effect var1);

    private void updateStageStyle(List<? extends String> removedStyles, List<? extends String> addedStyles) {
        if (this.updateLock) {
            return;
        }
        this.updateLock = true;
        if (removedStyles == null || !removedStyles.isEmpty()) {
            // empty if block
        }
        if (addedStyles != null && !addedStyles.isEmpty()) {
            Iterator<? extends String> iterator = addedStyles.iterator();
            while (iterator.hasNext()) {
                String newStyle;
                switch (newStyle = iterator.next()) {
                    case "cross-platform": {
                        this.setCrossPlatformStyleEnabled(true);
                        break;
                    }
                    case "native": {
                        this.setNativeStyleEnabled(true);
                        break;
                    }
                    case "undecorated": {
                        this.setUndecoratedStyleEnabled(true);
                        break;
                    }
                }
            }
        }
        this.updateLock = false;
    }

    private static class WindowButton
    extends Button {
        WindowButton(String name) {
            this.getStyleClass().setAll((Object[])new String[]{"window-button"});
            this.getStyleClass().add((Object)("window-" + name + "-button"));
            StackPane graphic = new StackPane();
            graphic.getStyleClass().setAll((Object[])new String[]{"graphic"});
            this.setGraphic((Node)graphic);
            this.setMinSize(17.0, 17.0);
            this.setPrefSize(17.0, 17.0);
        }
    }
}

