/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;

public class SSDPNetworkClient {
    private static final String DISCOVER_MESSAGE = "M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nMAN: \"ssdp:discover\"\r\nMX: 1\r\nST: urn:schemas-upnp-org:device:ZonePlayer:1\r\n\r\n";

    public void multicast() throws IOException {
        try {
            InetAddress multicastAddress = InetAddress.getByName("239.255.255.250");
            int port = 1900;
            MulticastSocket socket = new MulticastSocket(1900);
            socket.setReuseAddress(true);
            socket.setSoTimeout(15000);
            socket.joinGroup(multicastAddress);
            byte[] txbuf = DISCOVER_MESSAGE.getBytes("UTF-8");
            DatagramPacket hi = new DatagramPacket(txbuf, txbuf.length, multicastAddress, 1900);
            socket.send(hi);
            System.out.println("SSDP discover sent");
            while (true) {
                byte[] rxbuf = new byte[8192];
                DatagramPacket packet = new DatagramPacket(rxbuf, rxbuf.length);
                socket.receive(packet);
                this.dumpPacket(packet);
            }
        }
        catch (SocketTimeoutException e) {
            System.out.println("Timeout");
            return;
        }
    }

    private void dumpPacket(DatagramPacket packet) throws IOException {
        InetAddress addr = packet.getAddress();
        System.out.println("Response from: " + addr);
        ByteArrayInputStream in = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
        this.copyStream(in, System.out);
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        BufferedOutputStream bout = new BufferedOutputStream(out);
        int c = bin.read();
        while (c != -1) {
            out.write((char)c);
            c = bin.read();
        }
        bout.flush();
    }

    public static void main(String[] args) throws Exception {
        System.exit(0);
    }
}

