/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp.sonos;

import eu.mihosoft.upnp.sonos.ZonePlayer;
import eu.mihosoft.upnp.sonos.ZonePlayers;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.model.ZoneGroupState;
import org.tensin.sonos.xml.ResultParser;
import org.xml.sax.SAXException;

class ZoneGroupService
extends AbstractService {
    public ZoneGroupService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:ZoneGroupTopology:1");
    }

    public ZoneGroupState getZoneGroupState() {
        String action = "GetZoneGroupState";
        SonosActionInvocation invocation = this.messageFactory.getMessage(this.getService(), action);
        this.executeImmediate(invocation);
        try {
            ZoneGroupState state = ResultParser.getGroupStateFromResult(invocation.getOutputAsString("ZoneGroupState"));
            return state;
        }
        catch (SAXException ex) {
            Logger.getLogger(ZoneGroupService.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void main(String[] args) {
        ZonePlayers p = ZonePlayers.discover();
        ZonePlayer zp = p.getPlayers(3000).get(0);
        System.out.println(zp.getZoneGroups(p).toString());
        System.exit(0);
    }
}

