/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp.sonos;

import eu.mihosoft.upnp.sonos.Utils;
import eu.mihosoft.upnp.sonos.ZoneGroup;
import eu.mihosoft.upnp.sonos.ZonePlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.model.message.header.UDAServiceTypeHeader;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.registry.DefaultRegistryListener;
import org.fourthline.cling.registry.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZonePlayers {
    private static final Logger LOG = LoggerFactory.getLogger(ZonePlayers.class);
    private final List<ZonePlayer> zones = Collections.synchronizedList(new ArrayList());
    private List<ZoneGroup> zoneGroups = Collections.synchronizedList(new ArrayList());

    public static ZonePlayers discover() {
        final ZonePlayers zonePlayers = new ZonePlayers();
        final UpnpServiceImpl lookupService = new UpnpServiceImpl();
        UpnpServiceImpl upnpService = new UpnpServiceImpl(new DefaultRegistryListener(){

            @Override
            public void remoteDeviceAdded(Registry registry, RemoteDevice device) {
                if (zonePlayers.isSonos(device)) {
                    ZonePlayer zP = new ZonePlayer(device, lookupService);
                    zonePlayers.add(zP);
                    zonePlayers.updateZoneGroups(zP, 3000L);
                }
            }
        });
        upnpService.getControlPoint().search(new UDAServiceTypeHeader(new UDAServiceType("AVTransport")), 120);
        return zonePlayers;
    }

    private void updateZoneGroups(ZonePlayer zP, long timeout) {
        this.zoneGroups.clear();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeout) {
            try {
                LOG.debug("Adding groups");
                this.zoneGroups.addAll(zP.getZoneGroups(this));
                break;
            }
            catch (Exception ex) {
                LOG.debug("zonegroups could not be added");
                Utils.sleep(100);
            }
        }
    }

    public List<ZoneGroup> getZoneGroups(int timeout) {
        this.getPlayers(timeout);
        this.zoneGroups = this.zoneGroups.stream().filter(ZonePlayers.distinctByKey(g -> g.getId())).collect(Collectors.toList());
        return this.zoneGroups;
    }

    public List<ZoneGroup> getDiscoveredZoneGroups() {
        this.zoneGroups = this.zoneGroups.stream().filter(ZonePlayers.distinctByKey(g -> g.getId())).collect(Collectors.toList());
        return this.zoneGroups;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public List<ZonePlayer> getPlayers(int timeout) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)timeout) {
            Utils.sleep(100);
        }
        return this.zones;
    }

    public List<ZonePlayer> getDiscoveredPlayers() {
        return this.zones;
    }

    public ZonePlayer get(String zoneName, int timeout) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < (long)timeout) {
            for (ZonePlayer zone : this.zones) {
                if (!zone.getZoneName().equalsIgnoreCase(zoneName)) continue;
                return zone;
            }
            Utils.sleep(100);
        }
        LOG.info("returning null");
        return null;
    }

    private void add(ZonePlayer zone) {
        this.zones.add(zone);
    }

    private boolean isSonos(RemoteDevice device) {
        return "urn:schemas-upnp-org:device:ZonePlayer:1".equals(device.getType().toString());
    }
}

