/*
 * Decompiled with CFR 0.152.
 */
package eu.mihosoft.upnp.sonos.demo;

import eu.mihosoft.upnp.sonos.Utils;
import eu.mihosoft.upnp.sonos.ZonePlayer;
import eu.mihosoft.upnp.sonos.ZonePlayers;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;

public class SonosAPIDemo {
    private static final Logger LOG = LoggerFactory.getLogger(SonosAPIDemo.class);

    public static void main(String ... args) throws SonosException, IOException {
        new SonosAPIDemo().doTest();
    }

    private void doTest() throws SonosException, IOException {
        Utils.configureLogging();
        ZonePlayers zonePlayers = ZonePlayers.discover();
        ZonePlayer zone = zonePlayers.get("woonkamer", 5000);
        if (zone == null) {
            LOG.error("Zone not found.");
            return;
        }
        LOG.info("Current track: {}", (Object)zone.getCurrentTrackName());
        LOG.info("Current volume: {}, muted: {}", (Object)zone.getVolume(), (Object)zone.isMuted());
        LOG.info("Current queue contents: {}", (Object)zone.getQueue());
        zone.setVolume(15);
        zone.playStartOfQueue();
        Utils.sleep(5000);
        zone.nextTrack();
        Utils.sleep(5000);
        zone.pause();
        LOG.info("Done.");
        Utils.sleep(1000);
        System.exit(0);
    }
}

