/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.profile.RemoteClientInfo;
import org.fourthline.cling.protocol.ReceivingAsync;
import org.fourthline.cling.transport.RouterException;

public abstract class ReceivingSync<IN extends StreamRequestMessage, OUT extends StreamResponseMessage>
extends ReceivingAsync<IN> {
    private static final Logger log = Logger.getLogger(UpnpService.class.getName());
    protected final RemoteClientInfo remoteClientInfo;
    protected OUT outputMessage;

    protected ReceivingSync(UpnpService upnpService, IN inputMessage) {
        super(upnpService, inputMessage);
        this.remoteClientInfo = new RemoteClientInfo((StreamRequestMessage)inputMessage);
    }

    public OUT getOutputMessage() {
        return this.outputMessage;
    }

    @Override
    protected final void execute() throws RouterException {
        this.outputMessage = this.executeSync();
        if (this.outputMessage != null && this.getRemoteClientInfo().getExtraResponseHeaders().size() > 0) {
            log.fine("Setting extra headers on response message: " + this.getRemoteClientInfo().getExtraResponseHeaders().size());
            ((UpnpMessage)this.outputMessage).getHeaders().putAll(this.getRemoteClientInfo().getExtraResponseHeaders());
        }
    }

    protected abstract OUT executeSync() throws RouterException;

    public void responseSent(StreamResponseMessage responseMessage) {
    }

    public void responseException(Throwable t) {
    }

    public RemoteClientInfo getRemoteClientInfo() {
        return this.remoteClientInfo;
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

