/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.IAdapterOutput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class AdapterBootConstants
implements IAdapterInput,
IAdapterOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterBootConstants.class);
    private static final int LIB_COLUMNS = 5;
    private String constantName;
    private List<String> excludedJars = new ArrayList<String>();
    public static final String START_JAR_ENTRY_PATTERN = ".*String (JAR_[^ ]*).*=.*\"(.*\\.jar)\".*";
    private boolean useRegExp;
    private String mode;
    private String destFileName;

    public static String guessEncoding() {
        String foundEncoding = System.getProperty("file.encoding", "UTF-8").toUpperCase().trim();
        return foundEncoding;
    }

    public static void replace(String filePathName, String oldString, String newString) throws DependencyException {
        StringBuilder sb = new StringBuilder();
        sb.append("Remplacement dans " + filePathName).append("\n");
        sb.append(" > Ancienne chaine : " + oldString).append("\n");
        sb.append(" > Nouvelle chaine : " + newString).append("\n");
        File file = new File(filePathName);
        BufferedReader br = null;
        InputStreamReader isr = null;
        OutputStreamWriter osw = null;
        try {
            isr = new InputStreamReader((InputStream)new FileInputStream(file), AdapterBootConstants.guessEncoding());
            br = new BufferedReader(isr);
            StringBuffer buffer = new StringBuffer();
            String line = br.readLine();
            while (line != null) {
                buffer.append(line + "\r\n");
                line = br.readLine();
            }
            String fileStr = null;
            try {
                fileStr = buffer.toString().replaceAll(oldString, newString);
            }
            catch (Exception e) {
                sb.append("Erreur de remplacement dans '" + oldString + "' : " + e.getMessage()).append("\n");
            }
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), AdapterBootConstants.guessEncoding());
            osw.write(fileStr);
        }
        catch (IOException e) {
            throw new DependencyException("Erreur remplacement chaine", e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                    isr = null;
                }
                if (br != null) {
                    br.close();
                    br = null;
                }
                if (osw != null) {
                    osw.close();
                    osw = null;
                }
            }
            catch (IOException ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }

    public static AdapterBootConstants buildAdapter(String destFileName) {
        AdapterBootConstants adapter = new AdapterBootConstants();
        adapter.setDestFileName(destFileName);
        return adapter;
    }

    public static AdapterBootConstants buildAdapter(String destFileName, String constantName) {
        AdapterBootConstants adapter = new AdapterBootConstants();
        adapter.setDestFileName(destFileName);
        adapter.setConstantName(constantName);
        return adapter;
    }

    public static IAdapterOutput buildAdapter(String destFileName, String constantName, boolean useRegExp) {
        AdapterBootConstants adapter = new AdapterBootConstants();
        adapter.setDestFileName(destFileName);
        adapter.setConstantName(constantName);
        adapter.setUseRegExp(useRegExp);
        return adapter;
    }

    public static AdapterBootConstants buildAdapter(String destFileName, String constantName, List<String> excludedJars) {
        AdapterBootConstants adapter = new AdapterBootConstants();
        adapter.setDestFileName(destFileName);
        adapter.setConstantName(constantName);
        adapter.setExcludedJars(excludedJars);
        return adapter;
    }

    public void addExcludedJar(String jar) {
        this.excludedJars.add(jar);
    }

    private String buildAllLibs(Collection<JarContainer> expectedBaseJars) {
        return this.buildAllLibs(expectedBaseJars, null);
    }

    private String buildAllLibs(Collection<JarContainer> expectedJars, List<String> excludedJars) {
        StringBuffer sb = new StringBuffer();
        Iterator<JarContainer> itr = expectedJars.iterator();
        int count = 0;
        while (itr.hasNext()) {
            String key;
            JarContainer item = itr.next();
            if (this.isExcludedName(item.getStartConstantsKey(), excludedJars)) continue;
            if (count > 0) {
                sb.append(", ");
            }
            if (count % 5 == 0) {
                sb.append("\n\t\t\t");
            }
            if (StringUtils.isNotEmpty((CharSequence)(key = item.getStartConstantsKey()))) {
                sb.append(key);
            } else {
                key = this.useRegExp ? item.buildStartConstantsRegExp() : item.getJarName();
                sb.append("\"").append(key).append("\"");
            }
            ++count;
        }
        return sb.toString();
    }

    @Override
    public void generate(Collection<JarContainer> jars) throws DependencyException {
        if (!new File(this.destFileName).exists()) {
            LOGGER.error("The file [" + this.destFileName + "] doesn't exist.");
        } else {
            LOGGER.info("Updating content for the file [" + this.destFileName + "]");
            for (JarContainer jar : jars) {
                if (!jar.hasOrigin(AdapterBootConstants.class)) continue;
                String oldJarDefinition = "public static final String " + jar.getStartConstantsKey() + " = \"[^\"]*\";";
                String newJarDefinition = "public static final String " + jar.getStartConstantsKey() + " = \"" + jar.getJarName() + "\";";
                AdapterBootConstants.replace(this.destFileName, oldJarDefinition, newJarDefinition);
            }
            String allLibs = this.buildAllLibs(jars, this.getExcludedJars());
            String allLibsDeclaration = "public static final String[] " + this.constantName + " = { " + allLibs + " };";
            LOGGER.info(allLibsDeclaration);
            AdapterBootConstants.replace(this.destFileName, "public static final String\\[\\] " + this.constantName + " = \\{[^\\}]*\\};", allLibsDeclaration);
        }
    }

    private BufferedReader getBufferedReader(String path) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(path);
        if (is == null) {
            is = ClassLoader.getSystemResourceAsStream(path);
        }
        if (is == null) {
            is = new FileInputStream(path);
        }
        return new BufferedReader(new InputStreamReader(is, AdapterBootConstants.guessEncoding()));
    }

    public String getConstantName() {
        return this.constantName;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public List<String> getExcludedJars() {
        return this.excludedJars;
    }

    public String getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return "Load and save from and to LTP java StartConstants file";
    }

    private boolean isExcludedName(String item, List<String> namesToCheck) {
        boolean result = false;
        Iterator<String> itr = namesToCheck.iterator();
        while (itr.hasNext() && !result) {
            String pattern = itr.next();
            if (!item.startsWith(pattern)) continue;
            result = true;
        }
        return result;
    }

    public boolean isUseRegExp() {
        return this.useRegExp;
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        return this.loadStartJavaContent(this.getDestFileName());
    }

    private Collection<JarContainer> loadStartJavaContent(String javaFileToUpdate) throws DependencyException {
        return this.loadStartJavaContent(javaFileToUpdate, START_JAR_ENTRY_PATTERN);
    }

    private Collection<JarContainer> loadStartJavaContent(String javaFileToUpdate, String jarEntryConstantPattern) throws DependencyException {
        ArrayList<JarContainer> startJavaLibs = new ArrayList<JarContainer>();
        try {
            BufferedReader br = this.getBufferedReader(javaFileToUpdate);
            String lineStartJava = null;
            Pattern pattern = Pattern.compile(jarEntryConstantPattern);
            String key = null;
            String value = null;
            while ((lineStartJava = br.readLine()) != null) {
                if (!Pattern.matches(jarEntryConstantPattern, lineStartJava)) continue;
                Matcher doubleMatcher = pattern.matcher(lineStartJava);
                if (doubleMatcher.find()) {
                    key = doubleMatcher.group(1);
                    value = doubleMatcher.group(2);
                }
                JarContainer jar = new JarContainer(AdapterBootConstants.class);
                jar.setStartConstantsKey(key);
                jar.setStartConstantsRegExp(value);
                jar.setJarName(value);
                startJavaLibs.add(jar);
            }
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
        return startJavaLibs;
    }

    public void setConstantName(String constantName) {
        this.constantName = constantName;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    public void setExcludedJars(List<String> excludedJars) {
        this.excludedJars = excludedJars;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setUseRegExp(boolean useRegExp) {
        this.useRegExp = useRegExp;
    }
}

