/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.EclipseClasspathHandler;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.IAdapterOutput;
import org.tensin.common.tools.boot.updater.JarContainer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AdapterEclipseClasspath
implements IAdapterInput,
IAdapterOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterEclipseClasspath.class);
    public static final String DEFAULT_ECLIPSE_CLASSPATH = ".classpath";
    private String eclipseClassPath = ".classpath";

    public static AdapterEclipseClasspath buildAdapter(String eclipseClasspath) {
        AdapterEclipseClasspath adapter = new AdapterEclipseClasspath();
        adapter.setEclipseClassPath(eclipseClasspath);
        return adapter;
    }

    @Override
    public void generate(Collection<JarContainer> jars) throws DependencyException {
        for (JarContainer jarContainer : jars) {
        }
    }

    public String getEclipseClassPath() {
        return this.eclipseClassPath;
    }

    @Override
    public String getName() {
        return "Load and save from and to eclipse .classpath XML file";
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        return this.loadClasspathContent();
    }

    private Collection<JarContainer> loadClasspathContent() throws DependencyException {
        return this.loadClasspathContent(this.getEclipseClassPath());
    }

    private Collection<JarContainer> loadClasspathContent(String path) throws DependencyException {
        ArrayList<JarContainer> result = new ArrayList();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser xmlParser = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            xmlParser = factory.newSAXParser();
            EclipseClasspathHandler xmlHandler = new EclipseClasspathHandler();
            xmlParser.parse((InputStream)fis, (DefaultHandler)xmlHandler);
            result = xmlHandler.getResults();
            Collections.sort(result);
        }
        catch (ParserConfigurationException e) {
            throw new DependencyException(e);
        }
        catch (SAXException e) {
            throw new DependencyException(e);
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.info("Erreur sur fermeture ressources" + e.getMessage());
                }
                fis = null;
            }
        }
        return result;
    }

    public void setEclipseClassPath(String eclipseClassPath) {
        this.eclipseClassPath = eclipseClassPath;
    }
}

