/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class AdapterMavenDependencyList
implements IAdapterInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterMavenDependencyList.class);
    private JarContainer currentJar = null;
    private String filePath = "maven_dependencies.txt";
    private String filePathXml = "maven_dependencies.xml";
    private String delimiter = ":";
    private String dependencyFileName;

    public static AdapterMavenDependencyList buildAdapter(String dependencyFileName) throws DependencyException {
        AdapterMavenDependencyList adapter = new AdapterMavenDependencyList();
        adapter.setDependencyFileName(dependencyFileName);
        if (!new File(dependencyFileName).isFile()) {
            throw new DependencyException("File [" + dependencyFileName + "] not found (should have been created previously with 'mvn dependency:list')");
        }
        return adapter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getDependencyFileName() {
        return this.dependencyFileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFilePathXml() {
        return this.filePathXml;
    }

    @Override
    public String getName() {
        return "Load maven dependencies list (from 'mvn dependency:list' output for file [" + this.getDependencyFileName() + "])";
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        StringBuilder sb = new StringBuilder("Results :\n");
        ArrayList<JarContainer> jars = new ArrayList<JarContainer>();
        try {
            Scanner scanner = new Scanner(new File(this.dependencyFileName));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (!StringUtils.isNotEmpty((CharSequence)line) || line.contains("project: MavenProject:")) continue;
                line = line.trim();
                if (!StringUtils.isNotEmpty((CharSequence)(line = line.replaceAll("artifact =", "")))) continue;
                String[] temp = line.split(this.delimiter);
                if (temp.length >= 4) {
                    sb.append("    Adding [").append(line).append("]").append("\n");
                    this.currentJar = new JarContainer(AdapterMavenDependencyList.class);
                    this.currentJar.setGroupId(temp[0].trim());
                    this.currentJar.setArtifactId(temp[1].trim());
                    this.currentJar.setVersion(temp[3].trim());
                    jars.add(this.currentJar);
                    continue;
                }
                sb.append("    Weird line not added [").append(line).append("]").append("\n");
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            throw new DependencyException(e);
        }
        finally {
            LOGGER.info(sb.toString());
        }
        return jars;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setDependencyFileName(String dependencyFileName) {
        this.dependencyFileName = dependencyFileName;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setfilePathXml(String filePathXml) {
        this.filePathXml = filePathXml;
    }

    private String updateDestinationWithStartConstants(JarContainer jar) {
        String key = jar.getKey();
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            key = jar.getJarName();
        }
        return jar.getDestinations();
    }
}

