/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.IAdapterOutput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class AdapterPomXml
implements IAdapterInput,
IAdapterOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterPomXml.class);
    private String destFileName;
    private String rootFileName;

    public static AdapterPomXml buildAdapter(String destFileName) {
        AdapterPomXml adapter = new AdapterPomXml();
        adapter.setDestFileName(destFileName);
        return adapter;
    }

    public static AdapterPomXml buildAdapter(String destFileName, String rootFileName) {
        AdapterPomXml adapter = new AdapterPomXml();
        adapter.setDestFileName(destFileName);
        adapter.setRootFileName(rootFileName);
        return adapter;
    }

    private String dumpDependencies(Collection<JarContainer> dependencies) {
        StringBuffer sb = new StringBuffer();
        sb.append("<dependencies>").append("\n");
        for (JarContainer dependency : dependencies) {
            if (StringUtils.isEmpty((CharSequence)dependency.getGroupId())) continue;
            sb.append("\t<dependency>").append("\n");
            sb.append("\t\t<groupId>").append(dependency.getGroupId()).append("</groupId>").append("\n");
            sb.append("\t\t<artifactId>").append(dependency.getArtifactId()).append("</artifactId>").append("\n");
            sb.append("\t\t<version>").append(dependency.getVersion()).append("</version>").append("\n");
            sb.append("\t</dependency>").append("\n");
        }
        sb.append("</dependencies>").append("\n");
        return sb.toString();
    }

    @Override
    public void generate(Collection<JarContainer> jars) throws DependencyException {
        this.updatePomAutonomeDefs(jars, this.getDestFileName());
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    @Override
    public String getName() {
        return "Load and save from and to Maven POM XML file";
    }

    public String getRootFileName() {
        return this.rootFileName;
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        ArrayList<JarContainer> result = new ArrayList<JarContainer>();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.loadPropertiesFromPom(properties, this.rootFileName);
        this.loadPropertiesFromPom(properties, this.destFileName);
        SAXBuilder sxb = new SAXBuilder();
        try {
            Document document = sxb.build(new File(this.destFileName));
            Element racine = document.getRootElement();
            Element eltDependencies = racine.getChild("dependencies", racine.getNamespace());
            List eltDependency = eltDependencies.getChildren("dependency", racine.getNamespace());
            for (Element element : eltDependency) {
                JarContainer jar = new JarContainer(AdapterPomXml.class);
                jar.setGroupId(this.loadText(element, "groupId", properties));
                jar.setArtifactId(this.loadText(element, "artifactId", properties));
                jar.setVersion(this.loadText(element, "version", properties));
                result.add(jar);
            }
        }
        catch (JDOMException e) {
            throw new DependencyException(e);
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
        return result;
    }

    private void loadPropertiesFromPom(Map<String, String> properties, String fileName) throws DependencyException {
        SAXBuilder sxb = new SAXBuilder();
        try {
            Document document = sxb.build(new File(fileName));
            Element racine = document.getRootElement();
            Element eltProperties = racine.getChild("properties", racine.getNamespace());
            List eltProperty = eltProperties.getChildren();
            for (Element element : eltProperty) {
                properties.put(element.getName(), element.getValue());
            }
        }
        catch (JDOMException e) {
            throw new DependencyException(e);
        }
        catch (IOException e) {
            throw new DependencyException(e);
        }
    }

    private String loadText(Element element, String key, Map<String, String> properties) {
        String s = element.getChildText(key, element.getNamespace());
        Pattern p = Pattern.compile(".*\\$\\{([^\\}]*)\\}.*");
        Matcher m = p.matcher(s);
        if (m.find()) {
            String propName = m.group();
            String propValue = properties.get(propName = propName.substring(2, propName.length() - 1));
            if (StringUtils.isNotEmpty((CharSequence)propValue)) {
                s = s.replace("${" + propName + "}", propValue);
            }
        }
        return s;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = destFileName;
    }

    public void setRootFileName(String rootFileName) {
        this.rootFileName = rootFileName;
    }

    private void updatePomAutonomeDefs(Collection<JarContainer> jars, String pomAutonomeDefsFileName) {
        LOGGER.info("Updating : " + pomAutonomeDefsFileName);
        Iterator<JarContainer> itr = jars.iterator();
        ArrayList<JarContainer> dependencies = new ArrayList<JarContainer>();
        while (itr.hasNext()) {
            JarContainer jar = itr.next();
            String jarName = jar.getJarName();
            JarContainer dependency = new JarContainer(AdapterPomXml.class);
            dependency.setJarName(jarName);
            dependencies.add(dependency);
        }
        LOGGER.info(this.dumpDependencies(dependencies));
    }
}

