/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.FilenameFilterJar;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class AdapterWebInfLib
implements IAdapterInput {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdapterWebInfLib.class);
    private String path;

    public static AdapterWebInfLib buildAdapter(String path) {
        AdapterWebInfLib adapter = new AdapterWebInfLib();
        adapter.setPath(path);
        return adapter;
    }

    @Override
    public String getName() {
        return "Load from web/WEB-INF/lib - or similar path - content";
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public Collection<JarContainer> load() throws DependencyException {
        ArrayList<JarContainer> result = new ArrayList<JarContainer>();
        File fileWebLibs = new File(this.path).getAbsoluteFile();
        if (fileWebLibs.isDirectory()) {
            FilenameFilterJar filter = new FilenameFilterJar();
            File[] liste = fileWebLibs.listFiles(filter);
            for (int i = 0; i < liste.length; ++i) {
                JarContainer jar = new JarContainer(AdapterWebInfLib.class);
                jar.setJarName(liste[i].getName());
                result.add(jar);
            }
        } else {
            throw new DependencyException("Unknow path [" + fileWebLibs.getAbsolutePath() + "]");
        }
        Collections.sort(result);
        return result;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

