/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.common.tools.boot.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.common.tools.boot.updater.AdapterApt;
import org.tensin.common.tools.boot.updater.AdapterBootConstants;
import org.tensin.common.tools.boot.updater.AdapterDump;
import org.tensin.common.tools.boot.updater.AdapterEclipseClasspath;
import org.tensin.common.tools.boot.updater.AdapterLTPXml;
import org.tensin.common.tools.boot.updater.AdapterMavenDependencyList;
import org.tensin.common.tools.boot.updater.AdapterPomXml;
import org.tensin.common.tools.boot.updater.AdapterWebInfLib;
import org.tensin.common.tools.boot.updater.DependencyException;
import org.tensin.common.tools.boot.updater.IAdapterInput;
import org.tensin.common.tools.boot.updater.IAdapterOutput;
import org.tensin.common.tools.boot.updater.JarContainer;

public class DependencyConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyConverter.class);
    private final Collection<Class<?>> inputAdapters = new ArrayList();
    private final Collection<Class<?>> outputAdapters = new ArrayList();

    public String dumpDifferences(Collection<JarContainer> jars) {
        TreeSet<String> jarsName = new TreeSet<String>();
        for (JarContainer jar : jars) {
            jarsName.add(jar.getJarName());
        }
        StringBuffer sb = new StringBuffer();
        for (String jarName : jarsName) {
            sb.append("    ").append(StringUtils.rightPad((String)jarName, (int)50)).append(" : ");
            boolean eclipse = false;
            boolean lib = false;
            boolean pom = false;
            boolean start = false;
            boolean xml = false;
            boolean dependencyList = false;
            String description = "";
            String destination = "";
            for (JarContainer jar : jars) {
                if (!jar.getJarName().equalsIgnoreCase(jarName)) continue;
                if (jar.hasOrigin(AdapterWebInfLib.class)) {
                    lib = true;
                }
                if (jar.hasOrigin(AdapterEclipseClasspath.class)) {
                    eclipse = true;
                }
                if (jar.hasOrigin(AdapterPomXml.class)) {
                    pom = true;
                }
                if (jar.hasOrigin(AdapterMavenDependencyList.class)) {
                    dependencyList = true;
                }
                if (jar.hasOrigin(AdapterBootConstants.class)) {
                    start = true;
                }
                if (!jar.hasOrigin(AdapterLTPXml.class)) continue;
                xml = true;
                description = jar.getDescription();
                destination = jar.getDestinations();
            }
            if (eclipse) {
                sb.append("ECLIPSE      ");
            } else {
                sb.append("             ");
            }
            if (lib) {
                sb.append("WEB-LIB      ");
            } else {
                sb.append("             ");
            }
            if (pom) {
                sb.append("POM          ");
            } else {
                sb.append("             ");
            }
            if (start) {
                sb.append("START        ");
            } else {
                sb.append("             ");
            }
            if (xml) {
                sb.append("XML          ");
            } else {
                sb.append("             ");
            }
            if (dependencyList) {
                sb.append("DEPENDENCIES       ");
            } else {
                sb.append("                   ");
            }
            sb.append(description).append(destination).append("\n");
        }
        return sb.toString();
    }

    private JarContainer getJarContainer(JarContainer jarContainer, List<JarContainer> results) {
        JarContainer result = null;
        for (JarContainer currentJarContainer : results) {
            if (currentJarContainer.getJarBaseName().compareTo(jarContainer.getJarBaseName()) != 0) continue;
            return currentJarContainer;
        }
        return result;
    }

    public String help() {
        StringBuffer sb = new StringBuffer("Input adapters : \n");
        for (Class<?> adapter : this.inputAdapters) {
            sb.append(" - ").append(adapter.getName()).append("\n");
        }
        sb.append("Output adapters : \n");
        for (Class<?> adapter : this.outputAdapters) {
            sb.append(" - ").append(adapter.getName()).append("\n");
        }
        return sb.toString();
    }

    private Collection<JarContainer> loadFromInputs(Collection<IAdapterInput> inputs) throws DependencyException {
        Iterator<IAdapterInput> itr = inputs.iterator();
        ArrayList<JarContainer> results = new ArrayList<JarContainer>();
        while (itr.hasNext()) {
            IAdapterInput adapter = itr.next();
            LOGGER.info("Chargement des jars depuis l'adapter [" + adapter.getName() + "]");
            for (JarContainer jarContainer : adapter.load()) {
                this.mergeResult(jarContainer, results);
            }
        }
        Collections.sort(results);
        return results;
    }

    private List<Object> merge(List<Object> liste1, List<Object> liste2) {
        for (Object o : liste2) {
            if (liste1.contains(o)) continue;
            liste1.add(o);
        }
        return liste1;
    }

    private void mergeResult(JarContainer jarContainer, List<JarContainer> results) {
        JarContainer otherJarContainer = this.getJarContainer(jarContainer, results);
        if (otherJarContainer == null) {
            results.add(jarContainer);
        } else {
            LOGGER.info("    Jar d\u00e9j\u00e0 pr\u00e9sent, non ajout\u00e9 mais infos compl\u00e9t\u00e9es [" + otherJarContainer + "]");
            otherJarContainer.addOrigins(jarContainer.getOrigins());
            otherJarContainer.setStartConstantsKey(jarContainer.getStartConstantsKey());
            otherJarContainer.setStartConstantsRegExp(jarContainer.getStartConstantsRegExp());
        }
    }

    public Collection<JarContainer> process(Collection<IAdapterInput> inputs, Collection<IAdapterOutput> outputs) throws DependencyException {
        Collection<JarContainer> jars = this.loadFromInputs(inputs);
        this.saveToOutputs(jars, outputs);
        return jars;
    }

    public void process(Collection<IAdapterInput> inputs, IAdapterOutput output) throws DependencyException {
        ArrayList<IAdapterOutput> l = new ArrayList<IAdapterOutput>();
        l.add(output);
        this.process(inputs, l);
    }

    public void process(IAdapterInput input, Collection<IAdapterOutput> outputs) throws DependencyException {
        ArrayList<IAdapterInput> l = new ArrayList<IAdapterInput>();
        l.add(input);
        this.process(l, outputs);
    }

    public void process(IAdapterInput input, IAdapterOutput output) throws DependencyException {
        ArrayList<IAdapterInput> inputs = new ArrayList<IAdapterInput>();
        inputs.add(input);
        ArrayList<IAdapterOutput> outputs = new ArrayList<IAdapterOutput>();
        outputs.add(output);
        this.process(inputs, outputs);
    }

    public void registerAdapters() throws DependencyException {
        this.registerInputAdapters();
        this.registerOutputAdapters();
    }

    protected void registerInputAdapters() throws DependencyException {
        this.inputAdapters.add(AdapterEclipseClasspath.class);
        this.inputAdapters.add(AdapterBootConstants.class);
        this.inputAdapters.add(AdapterLTPXml.class);
        this.inputAdapters.add(AdapterPomXml.class);
        this.inputAdapters.add(AdapterWebInfLib.class);
    }

    protected void registerOutputAdapters() throws DependencyException {
        this.outputAdapters.add(AdapterEclipseClasspath.class);
        this.outputAdapters.add(AdapterBootConstants.class);
        this.outputAdapters.add(AdapterLTPXml.class);
        this.outputAdapters.add(AdapterPomXml.class);
        this.outputAdapters.add(AdapterApt.class);
        this.outputAdapters.add(AdapterDump.class);
    }

    private void saveToOutputs(Collection<JarContainer> jars, Collection<IAdapterOutput> outputs) throws DependencyException {
        for (IAdapterOutput adapter : outputs) {
            adapter.generate(jars);
        }
    }
}

