/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commander;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.model.message.header.UDAServiceTypeHeader;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.types.UDAServiceType;
import org.fourthline.cling.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.AbstractCommand;
import org.tensin.sonos.commands.IStandardCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.commands.ZoneCommandDispatcher;
import org.tensin.sonos.control.ZoneGroupTopologyListener;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.helpers.CollectionHelper;
import org.tensin.sonos.model.ZoneGroup;
import org.tensin.sonos.model.ZoneGroupState;
import org.tensin.sonos.model.ZoneGroupStateModel;
import org.tensin.sonos.model.ZonePlayerModel;

public abstract class AbstractController
implements ZoneGroupTopologyListener {
    private final ZoneCommandDispatcher zoneCommandDispatcher = ZoneCommandDispatcher.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractController.class);
    private static final int DEFAULT_UDP_SEARCH_TIME = 120;
    private Collection<String> zonesToWorkOn;
    private boolean workOnAllZones = false;
    private boolean debug;
    private final ZoneGroupStateModel groups = new ZoneGroupStateModel();
    private final ZonePlayerModel zonePlayers = new ZonePlayerModel();
    private final Map<String, Long> zonePlayerDiscoveries = new HashMap<String, Long>();
    private UpnpService upnpService;
    private Collection<IZoneCommand> commandStackZone;
    private Collection<IStandardCommand> commandStackStandard;
    private int udpSearchTime = 120;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZonePlayer addZonePlayer(RemoteDevice dev) {
        ZonePlayerModel zonePlayerModel = this.zonePlayers;
        synchronized (zonePlayerModel) {
            this.zonePlayerDiscoveries.put(((RemoteDeviceIdentity)dev.getIdentity()).getUdn().getIdentifierString().substring(5), System.currentTimeMillis());
            if (this.isZonePlayerAlreadyDefined(((RemoteDeviceIdentity)dev.getIdentity()).getUdn().getIdentifierString())) {
                return null;
            }
            ArrayList<String> ignoredDevicesModelName = new ArrayList<String>();
            ignoredDevicesModelName.add("ZB100");
            ignoredDevicesModelName.add("BR100");
            for (String ignoredDeviceModelName : ignoredDevicesModelName) {
                if (!dev.getDetails().getModelDetails().getModelNumber().toUpperCase().contains("ZB100")) continue;
                return null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Adding zone: " + dev.getType().getDisplayString() + " " + dev.getDetails().getModelDetails().getModelDescription() + " " + dev.getDetails().getModelDetails().getModelName() + " " + dev.getDetails().getModelDetails().getModelNumber());
            }
            try {
                ZonePlayer zone = new ZonePlayer(this.upnpService, dev);
                this.zonePlayers.addZonePlayer(zone);
                zone.getZoneGroupTopologyService().addZoneGroupTopologyListener(this);
                this.zoneGroupTopologyChanged(zone.getZoneGroupTopologyService().getGroupState());
                return zone;
            }
            catch (Exception e) {
                LOGGER.error("Couldn't add zone" + dev.getType().getDisplayString() + " " + dev.getDetails().getModelDetails().getModelDescription() + " " + dev.getDetails().getModelDetails().getModelName() + " " + dev.getDetails().getModelDetails().getModelNumber(), e);
                return null;
            }
        }
    }

    protected void detectIfWorkOnAllZones() {
        if (this.zonesToWorkOn == null || this.zonesToWorkOn.size() == 0) {
            this.workOnAllZones = true;
        } else {
            Iterator<String> itr = this.zonesToWorkOn.iterator();
            while (itr.hasNext()) {
                String s = itr.next();
                if (!s.equalsIgnoreCase("ALL")) continue;
                itr.remove();
                this.workOnAllZones = true;
            }
        }
        if (this.workOnAllZones) {
            LOGGER.info("Working on all available zones");
        } else {
            LOGGER.info("Working on zones " + CollectionHelper.singleDump(this.zonesToWorkOn).toUpperCase() + "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ZonePlayerModel zonePlayerModel = this.zonePlayers;
        synchronized (zonePlayerModel) {
            for (ZonePlayer zp : this.zonePlayers.getAllZones()) {
                zp.dispose();
            }
        }
    }

    public void executeStandardCommands() throws SonosException {
        if (!CollectionUtils.isEmpty(this.getCommandStackStandard())) {
            for (IStandardCommand command : this.getCommandStackStandard()) {
                command.execute();
            }
        }
    }

    public void executeZoneCommands(String zone, List<String> parameters) throws SonosException {
        if (!CollectionUtils.isEmpty(this.getCommandStackZone())) {
            this.setZonesToWorkOn(CollectionHelper.convertStringToCollection(zone));
            this.detectIfWorkOnAllZones();
            if (!this.isWorkOnAllZones()) {
                for (IZoneCommand command : this.getCommandStackZone()) {
                    ((AbstractCommand)((Object)command)).setArgs(parameters);
                    for (String zoneToWorkOn : this.getZonesToWorkOn()) {
                        this.zoneCommandDispatcher.dispatchCommand(command, zoneToWorkOn);
                    }
                }
            }
            this.zoneCommandDispatcher.waitEndExecution(20000, !this.isWorkOnAllZones());
        }
    }

    public Collection<IStandardCommand> getCommandStackStandard() {
        return this.commandStackStandard;
    }

    public Collection<IZoneCommand> getCommandStackZone() {
        return this.commandStackZone;
    }

    public ZonePlayer getCoordinatorForZonePlayer(ZonePlayer zp) {
        if (zp == null || zp.getZoneGroupTopologyService().getGroupState() == null) {
            return zp;
        }
        for (ZoneGroup zg : zp.getZoneGroupTopologyService().getGroupState().getGroups()) {
            if (!zg.getMembers().contains(zp.getId())) continue;
            return this.getZonePlayerModel().getById(zg.getCoordinator());
        }
        return zp;
    }

    public abstract RegistryListener getListener();

    public int getUdpSearchTime() {
        return this.udpSearchTime;
    }

    public ZoneGroupStateModel getZoneGroupStateModel() {
        return this.groups;
    }

    public ZonePlayer getZonePlayerByUDN(String UDN2) {
        for (ZonePlayer zone : this.zonePlayers.getAllZones()) {
            if (!((RemoteDeviceIdentity)zone.getRootDevice().getIdentity()).getUdn().getIdentifierString().equals(UDN2)) continue;
            return zone;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZonePlayerModel getZonePlayerModel() {
        ZonePlayerModel zonePlayerModel = this.zonePlayers;
        synchronized (zonePlayerModel) {
            return this.zonePlayers;
        }
    }

    public Collection<String> getZonesToWorkOn() {
        return this.zonesToWorkOn;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isWorkOnAllZones() {
        return this.workOnAllZones;
    }

    public boolean isZonePlayerAlreadyDefined(String UDN2) {
        ZonePlayer other = this.getZonePlayerByUDN(UDN2);
        return other != null;
    }

    public void purgeStaleDevices(long staleThreshold) {
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Long> zone : this.zonePlayerDiscoveries.entrySet()) {
            if (now - zone.getValue() <= staleThreshold) continue;
            this.removeZonePlayer(zone.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeZonePlayer(String udn) {
        ZonePlayerModel zonePlayerModel = this.zonePlayers;
        synchronized (zonePlayerModel) {
            ZonePlayer zp = this.zonePlayers.getById(udn);
            if (zp != null) {
                LOGGER.info("Removing ZonePlayer " + udn + " " + zp.getRootDevice().getDetails().getModelDetails().getModelDescription());
                this.zonePlayers.remove(zp);
                zp.getZoneGroupTopologyService().removeZoneGroupTopologyListener(this);
                if (this.zonePlayers.getSize() == 0) {
                    this.zoneGroupTopologyChanged(new ZoneGroupState(Collections.EMPTY_LIST));
                }
                zp.dispose();
            }
        }
    }

    public void setCommandStackStandard(Collection<IStandardCommand> commandStackStandard) {
        this.commandStackStandard = commandStackStandard;
    }

    public void setCommandStackZone(Collection<IZoneCommand> commandStackZone) {
        this.commandStackZone = commandStackZone;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUdpSearchTime(int udpSearchTime) {
        this.udpSearchTime = udpSearchTime;
    }

    public void setWorkOnAllZones(boolean workOnAllZones) {
        this.workOnAllZones = workOnAllZones;
    }

    public void setZonesToWorkOn(Collection<String> zonesToWorkOn) {
        this.zonesToWorkOn = zonesToWorkOn;
    }

    public void shutdown() {
        LOGGER.info("Shutting down UPNP services and discovery");
        this.upnpService.shutdown();
        LOGGER.info("Cleaning up internal resources");
        this.dispose();
    }

    public void startDiscovery() {
        this.upnpService = new UpnpServiceImpl(this.getListener());
        UDAServiceType udaType = new UDAServiceType("AVTransport");
        this.upnpService.getControlPoint().search(new UDAServiceTypeHeader(udaType), this.getUdpSearchTime());
    }

    @Override
    public synchronized void zoneGroupTopologyChanged(ZoneGroupState groupState) {
        if (groupState == null) {
            return;
        }
        this.groups.handleGroupUpdate(groupState);
    }
}

