/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commander;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.tensin.sonos.LogInitializer;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commander.ISonosController;
import org.tensin.sonos.commander.JavaController;
import org.tensin.sonos.commands.CommandFactory;
import org.tensin.sonos.commands.ICommand;
import org.tensin.sonos.commands.IStandardCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.commands.ZoneCommandDispatcher;
import org.tensin.sonos.helpers.CollectionHelper;
import org.tensin.sonos.helpers.SystemHelper;

public class CLIController
extends JavaController
implements ISonosController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLIController.class);
    @Parameter(names={"--zone", "-z"}, description="Sonos zone logic name to run command on. Put 'ALL' for interacting on all zones, or separate zones with comma. Valid examples are : '-z kitchen', '-z ALL', '-z kitchen,room', '-z 192.168.1.54'.")
    private String zone = "";
    @Parameter(names={"--command", "-c"}, description="Command to be run")
    private String command;
    @Parameter(names={"--debug"}, description="Debug mode")
    private boolean debug;
    @Parameter(names={"-h", "--usage", "--help"}, description="Shows available commands")
    private boolean usage;
    @Parameter(description="Additionnal command parameters")
    private List<String> parameters = new ArrayList<String>();
    private static SystemHelper systemHelper = new SystemHelper();
    private final ZoneCommandDispatcher zoneCommandDispatcher = ZoneCommandDispatcher.getInstance();

    public static CLIController createController() {
        return new CLIController();
    }

    public static SystemHelper getSystemHelper() {
        return systemHelper;
    }

    public static void main(String[] args) throws SonosException {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        CLIController a = CLIController.createController();
        a.start(args);
    }

    public static void setSystemHelper(SystemHelper systemHelper) {
        CLIController.systemHelper = systemHelper;
    }

    protected CLIController() {
    }

    private void buildJCommanderFromCommandLine(String[] args) throws SonosException {
        JCommander jCommander = null;
        try {
            jCommander = new JCommander((Object)this, args);
        }
        catch (ParameterException e) {
            LOGGER.error("The given options haven't been recognized : " + CollectionHelper.singleDump(Arrays.asList(args)));
            jCommander = new JCommander((Object)this);
            this.usage(jCommander);
        }
        if (this.usage || args == null || args.length == 0) {
            this.usage(jCommander);
        }
        if (this.debug) {
            LOGGER.info("Debug activated");
        }
        Collection<String> commandsAvailables = CollectionHelper.convertStringToCollection(this.command);
        this.setCommandStackZone(CommandFactory.createCommandStack(commandsAvailables, IZoneCommand.class));
        this.setCommandStackStandard(CommandFactory.createCommandStack(commandsAvailables, IStandardCommand.class));
        if (!this.checkAllCommandsHaveBeenMapped(commandsAvailables)) {
            LOGGER.error("The following commands haven't been recognized : " + CollectionHelper.singleDump(commandsAvailables));
            this.usage(jCommander);
        }
        this.extractParameters();
        if (this.getCommandStackZone().size() == 0 && this.getCommandStackStandard().size() == 0) {
            this.usage(jCommander);
        }
        LOGGER.debug("Standard commands to run : \n" + CollectionHelper.singleDump(this.getCommandStackStandard()));
        LOGGER.debug("Zone commands to run : \n" + CollectionHelper.singleDump(this.getCommandStackZone()));
    }

    private boolean checkAllCommandsHaveBeenMapped(Collection<String> commandsAvailables) {
        return CollectionUtils.isEmpty(commandsAvailables);
    }

    private void extractParameters() {
        boolean zoneCommandFound = false;
        for (String parameter : this.getParameters()) {
            if (zoneCommandFound) {
                if (StringUtils.isEmpty((CharSequence)this.zone)) {
                    this.zone = parameter;
                }
                zoneCommandFound = false;
                continue;
            }
            for (ICommand c : CommandFactory.getAvailableCommands(ICommand.class)) {
                if (!c.getName().equalsIgnoreCase(parameter)) continue;
                if (c instanceof IStandardCommand) {
                    this.getCommandStackStandard().add((IStandardCommand)c);
                }
                if (!(c instanceof IZoneCommand)) continue;
                this.getCommandStackZone().add((IZoneCommand)c);
                zoneCommandFound = true;
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public String getZone() {
        return this.zone;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    private void start(String[] args) throws SonosException {
        try {
            LogInitializer.initLog();
            this.buildJCommanderFromCommandLine(args);
            this.startDiscovery();
            this.executeStandardCommands();
            this.executeZoneCommands(this.zone, this.parameters);
        }
        finally {
            this.shutdown();
            this.zoneCommandDispatcher.logSummary();
            this.zoneCommandDispatcher.stopExecutors();
            systemHelper.exit(0);
        }
    }

    private void usage(JCommander jCommander) {
        StringBuilder sb = new StringBuilder();
        jCommander.usage(sb);
        sb.append("\n");
        sb.append("  Commands :").append("\n");
        for (ICommand c : CommandFactory.getAvailableCommands(ICommand.class)) {
            boolean needArgs = c.needArgs();
            String description = c.getDescription();
            sb.append("    ").append(StringUtils.rightPad((String)c.getName(), (int)30, (String)" "));
            if (StringUtils.isNotEmpty((CharSequence)description)) {
                sb.append(" : ").append(description);
            }
            if (needArgs) {
                sb.append(" [additionnal parameters needed]");
            }
            sb.append("\n");
        }
        sb.append("\n");
        sb.append("  Examples :\n");
        sb.append("    --command play --zone kitchen,room        Starts music in kitchen and room").append("\n");
        sb.append("    --command volume 25 --zone kitchen        Set volume to 25 in kitchen").append("\n");
        sb.append("    --command pause --zone all                Pause all found zones").append("\n");
        sb.append("    --command pause                           Pause all found zones").append("\n");
        systemHelper.outln(sb.toString());
        systemHelper.exit(0);
    }
}

