/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commander;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.LogInitializer;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commander.AbstractController;
import org.tensin.sonos.commander.ISonosController;
import org.tensin.sonos.commands.CommandFactory;
import org.tensin.sonos.commands.IStandardCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.commands.ZoneCommandDispatcher;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.helpers.CollectionHelper;
import org.tensin.sonos.helpers.RemoteDeviceHelper;

public class JavaController
extends AbstractController
implements ISonosController {
    private final Executor controllerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "SonosControllerThread");
            t.setDaemon(true);
            return t;
        }
    });
    private final RegistryListener listener = new RegistryListener(){

        @Override
        public void afterShutdown() {
        }

        @Override
        public void beforeShutdown(Registry registry) {
        }

        private boolean isConcernedDevice(RemoteDevice device) {
            return device.getDetails().getManufacturerDetails().getManufacturer().toUpperCase().contains("SONOS");
        }

        @Override
        public void localDeviceAdded(Registry registry, LocalDevice device) {
        }

        @Override
        public void localDeviceRemoved(Registry registry, LocalDevice device) {
        }

        @Override
        public void remoteDeviceAdded(Registry registry, final RemoteDevice device) {
            if (this.isConcernedDevice(device)) {
                JavaController.this.controllerExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        LOGGER.debug(RemoteDeviceHelper.dumpRemoteDevice(device));
                        ZonePlayer zone = JavaController.this.addZonePlayer(device);
                        if (zone != null) {
                            String name = zone.getDevicePropertiesService().getZoneAttributes().getName();
                            JavaController.this.zoneCommandDispatcher.registerZoneAsAvailable(zone, name);
                            if (JavaController.this.isWorkOnAllZones()) {
                                for (IZoneCommand command : JavaController.this.getCommandStackZone()) {
                                    JavaController.this.zoneCommandDispatcher.dispatchCommand(command, name);
                                }
                            }
                        }
                    }
                });
            }
        }

        @Override
        public void remoteDeviceDiscoveryFailed(Registry registry, RemoteDevice device, Exception ex) {
        }

        @Override
        public void remoteDeviceDiscoveryStarted(Registry registry, RemoteDevice device) {
        }

        @Override
        public void remoteDeviceRemoved(Registry registry, final RemoteDevice device) {
            if (this.isConcernedDevice(device)) {
                JavaController.this.controllerExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        JavaController.this.removeZonePlayer(((RemoteDeviceIdentity)device.getIdentity()).getUdn().toString());
                        LOGGER.info("Device [" + ((RemoteDeviceIdentity)device.getIdentity()).getUdn().toString() + "] disconnected");
                    }
                });
            }
        }

        @Override
        public void remoteDeviceUpdated(Registry registry, RemoteDevice device) {
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaController.class);
    private final ZoneCommandDispatcher zoneCommandDispatcher = ZoneCommandDispatcher.getInstance();

    public static JavaController createController() {
        return new JavaController();
    }

    @Override
    public void execute(String command) throws SonosException {
        this.execute("ALL", command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(String zoneNames, String command) throws SonosException {
        LogInitializer.initLog();
        if (StringUtils.isEmpty((CharSequence)command)) {
            LOGGER.error("No command provided, won't do anything");
        } else {
            try {
                this.startDiscovery();
                Collection<String> commandsAvailables = CollectionHelper.convertStringToCollection(command);
                this.setCommandStackZone(CommandFactory.createCommandStack(commandsAvailables, IZoneCommand.class));
                this.setCommandStackStandard(CommandFactory.createCommandStack(commandsAvailables, IStandardCommand.class));
                this.executeStandardCommands();
                this.executeZoneCommands(zoneNames, new ArrayList<String>());
            }
            finally {
                this.shutdown();
                this.zoneCommandDispatcher.logSummary();
                this.zoneCommandDispatcher.stopExecutors();
            }
        }
    }

    @Override
    public RegistryListener getListener() {
        return this.listener;
    }
}

