/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.AbstractCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.control.BrowseHandle;
import org.tensin.sonos.control.EntryCallback;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.model.Entry;

public class CommandBrowse
extends AbstractCommand
implements IZoneCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandBrowse.class);
    private EntryCallback callback = new EntryCallback(){
        private final StringBuilder sb = new StringBuilder();

        @Override
        public void addEntries(BrowseHandle handle, Collection<Entry> entries) {
            for (Entry entry : entries) {
                this.sb.append(" - ").append(entry.getTitle()).append("\n");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void retrievalComplete(BrowseHandle handle, boolean completedSuccessfully) {
            LOGGER.info(this.sb.toString());
            BrowseHandle browseHandle = handle;
            synchronized (browseHandle) {
                handle.notify();
            }
        }

        @Override
        public void updateCount(BrowseHandle handle, int count) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ZonePlayer sonos) throws SonosException {
        BrowseHandle handle = sonos.getMediaServerDevice().getContentDirectoryService().getAllEntriesAsync(this.callback, this.getArgs().get(0));
        try {
            BrowseHandle browseHandle = handle;
            synchronized (browseHandle) {
                handle.wait();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public EntryCallback getCallback() {
        return this.callback;
    }

    @Override
    public String getDescription() {
        return "Browse the sonos informations";
    }

    @Override
    public String getName() {
        return "browse";
    }

    @Override
    public boolean needArgs() {
        return true;
    }

    public void setCallback(EntryCallback callback) {
        this.callback = callback;
    }
}

