/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.AbstractCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.control.BrowseHandle;
import org.tensin.sonos.control.EntryCallback;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.model.Entry;

public class CommandGetArtists
extends AbstractCommand
implements IZoneCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandGetArtists.class);

    @Override
    public void execute(ZonePlayer sonos) throws SonosException {
        final long start = System.currentTimeMillis();
        final StringBuilder sb = new StringBuilder();
        final ArrayList allEntries = new ArrayList();
        BrowseHandle handle = sonos.getMediaServerDevice().getContentDirectoryService().getAllEntriesAsync(new EntryCallback(){

            @Override
            public void addEntries(BrowseHandle handle, Collection<Entry> entries) {
                allEntries.addAll(entries);
            }

            @Override
            public void retrievalComplete(BrowseHandle handle, boolean completedSuccessfully) {
                Collections.sort(allEntries);
                for (Entry entry : allEntries) {
                    sb.append(" - ").append(entry.getTitle()).append("\n");
                }
                LOGGER.info(sb.toString());
                System.out.println(System.currentTimeMillis() - start + "ms");
            }

            @Override
            public void updateCount(BrowseHandle handle, int count) {
            }
        }, "A:ARTIST");
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getName() {
        return "getartists";
    }
}

