/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.AbstractCommand;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.control.ZonePlayer;

public class CommandVolume
extends AbstractCommand
implements IZoneCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandVolume.class);

    @Override
    public void execute(ZonePlayer sonos) throws SonosException {
        if (!this.hasArgs()) {
            int n = sonos.getMediaRendererDevice().getRenderingControlService().getVolume();
            LOGGER.info("Volume is [" + n + "]");
        } else {
            sonos.getMediaRendererDevice().getRenderingControlService().setVolume(Integer.parseInt(this.getArgs().get(0)));
        }
    }

    @Override
    public String getDescription() {
        return "Set volume to a given level [0-100]";
    }

    @Override
    public String getName() {
        return "volume";
    }

    @Override
    public boolean needArgs() {
        return true;
    }
}

