/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.commands.CommandPoisonPill;
import org.tensin.sonos.commands.IZoneCommand;
import org.tensin.sonos.commands.IZoneCommandDispatcher;
import org.tensin.sonos.commands.ZoneCommandExecutor;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.helpers.TimeUtilities;

public class ZoneCommandDispatcher
implements IZoneCommandDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZoneCommandDispatcher.class);
    private boolean noCommandExecuted = true;
    private final Map<String, ZoneCommandExecutor> executors = new HashMap<String, ZoneCommandExecutor>();
    private static final ZoneCommandDispatcher INSTANCE = new ZoneCommandDispatcher();

    public static ZoneCommandDispatcher getInstance() {
        return INSTANCE;
    }

    @Override
    public void dispatchCommand(IZoneCommand command, String zoneName) {
        LOGGER.debug("Dispatching [" + command.getName() + "]");
        ZoneCommandExecutor executor = this.registerZoneExecutor(zoneName);
        executor.addCommand(command);
        this.noCommandExecuted = false;
    }

    @Override
    public Map<String, ZoneCommandExecutor> getExecutors() {
        return this.executors;
    }

    @Override
    public ZoneCommandExecutor getZoneCommandExecutor(String zoneName) {
        if (this.executors.containsKey(zoneName.toUpperCase())) {
            return this.executors.get(zoneName.toUpperCase());
        }
        return null;
    }

    @Override
    public Collection<String> getZonesNames() {
        return this.executors.keySet();
    }

    @Override
    public void logSummary() {
        StringBuilder sb = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        int problems = 0;
        int reports = 0;
        for (Map.Entry<String, ZoneCommandExecutor> entry : this.executors.entrySet()) {
            ZoneCommandExecutor executor = entry.getValue();
            if (executor.getSonosZone() == null) {
                sb.append("- Zone [" + executor.getZoneName() + "] hasn't been found on the network by discovery !\n");
                ++problems;
            } else {
                summary.append("- Zone [" + executor.getZoneName() + "], executed commands count = " + executor.getExecutedCommandsCount() + "\n");
                ++reports;
            }
            if (!executor.hasNoCommandLeft()) {
                sb.append("- Zone [" + executor.getZoneName() + "] has " + executor.getCommandLeftCount() + " awaiting command(s) that won't be processed.\n");
                ++problems;
            }
            if (!executor.hasRunningCommand()) continue;
            sb.append("- Zone [" + executor.getZoneName() + "] has 1 running command that will be killed.\n");
            ++problems;
        }
        if (problems > 0) {
            LOGGER.error("Problems found before terminating program : \n" + sb.toString());
        }
        if (reports > 0) {
            LOGGER.info("Summary :\n" + summary.toString());
        }
    }

    @Override
    public void registerZoneAsAvailable(ZonePlayer sonos, String zoneName) {
        ZoneCommandExecutor executor = this.registerZoneExecutor(zoneName);
        executor.registerZoneAsAvailable(sonos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZoneCommandExecutor registerZoneExecutor(String zoneName) {
        ZoneCommandExecutor executor;
        String zoneNameUppercase = zoneName.toUpperCase();
        Map<String, ZoneCommandExecutor> map = this.executors;
        synchronized (map) {
            if (!this.executors.containsKey(zoneNameUppercase)) {
                executor = new ZoneCommandExecutor(zoneNameUppercase);
                executor.start();
                this.executors.put(zoneNameUppercase, executor);
            } else {
                executor = this.executors.get(zoneNameUppercase);
            }
        }
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetInstance() throws SonosException {
        this.stopExecutors();
        Map<String, ZoneCommandExecutor> map = this.executors;
        synchronized (map) {
            this.executors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExecutors() throws SonosException {
        Map<String, ZoneCommandExecutor> map = this.executors;
        synchronized (map) {
            for (Map.Entry<String, ZoneCommandExecutor> entry : this.executors.entrySet()) {
                ZoneCommandExecutor executor = entry.getValue();
                executor.halt();
                executor.addCommand(new CommandPoisonPill());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitEndExecution(int delay, boolean checkEmptyQueues) throws SonosException {
        long start = System.currentTimeMillis();
        boolean active = true;
        boolean firstPass = true;
        while (active) {
            TimeUtilities.waitMilliSeconds(250L);
            long current = System.currentTimeMillis();
            if (current > start + (long)delay) {
                active = false;
                continue;
            }
            if (checkEmptyQueues) {
                Map<String, ZoneCommandExecutor> map = this.executors;
                synchronized (map) {
                    boolean allCommandsProcessed = true;
                    boolean allCommandsEnded = true;
                    for (Map.Entry<String, ZoneCommandExecutor> entry : this.executors.entrySet()) {
                        ZoneCommandExecutor executor = entry.getValue();
                        if (!executor.hasNoCommandLeft()) {
                            allCommandsProcessed = false;
                            break;
                        }
                        if (!executor.hasRunningCommand()) continue;
                        allCommandsEnded = false;
                        break;
                    }
                    if (allCommandsProcessed && allCommandsEnded && !this.noCommandExecuted) {
                        active = false;
                    }
                    continue;
                }
            }
            if (!firstPass) continue;
            LOGGER.info("As no zone has been specified to work on, we wait a bit to be sure that every zone has been discovered on the network ...");
            firstPass = false;
        }
    }
}

