/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.Service;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.SonosActionInvocation;
import org.tensin.sonos.model.ZoneAttributes;
import org.tensin.sonos.model.ZoneInfo;

public class DevicePropertiesService
extends AbstractService {
    protected DevicePropertiesService(UpnpService upnpService, Service service) {
        super(upnpService, service, "urn:schemas-upnp-org:service:DeviceProperties:1");
    }

    public String getHouseholdID() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetHouseholdID");
        this.executeImmediate(message);
        return message.getOutputAsString("HouseholdID");
    }

    public boolean getInvisible() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetInvisible");
        this.executeImmediate(message);
        return Boolean.parseBoolean(message.getOutputAsString("CurrentInvisible"));
    }

    public boolean getLEDState() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetLEDState");
        this.executeImmediate(message);
        String state = message.getOutputAsString("CurrentLEDState");
        return "On".equals(state);
    }

    public ZoneAttributes getZoneAttributes() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetZoneAttributes");
        this.executeImmediate(message);
        return new ZoneAttributes(message.getOutputAsString("CurrentZoneName"), message.getOutputAsString("CurrentIcon"));
    }

    public ZoneInfo getZoneInfo() {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "GetZoneInfo");
        this.executeImmediate(message);
        return new ZoneInfo(message.getOutputAsString("SerialNumber"), message.getOutputAsString("SoftwareVersion"), message.getOutputAsString("DisplaySoftwareVersion"), message.getOutputAsString("HardwareVersion"), message.getOutputAsString("IPAddress"), message.getOutputAsString("MACAddress"), message.getOutputAsString("CopyrightInfo"), message.getOutputAsString("ExtraInfo"));
    }

    public void handleStateVariableEvent(String varName, String newValue) {
    }

    public void setInvisible(boolean isInvisible) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetInvisible");
        message.setInput("DesiredInvisible", isInvisible ? "1" : "0");
        this.execute(message);
    }

    public void setLEDState(boolean ledEnabled) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetLEDState");
        message.setInput("DesiredLEDState", ledEnabled ? "On" : "Off");
        this.execute(message);
    }

    public void setZoneAttributes(ZoneAttributes atts) {
        SonosActionInvocation message = this.messageFactory.getMessage(this.getService(), "SetZoneAttributes");
        message.setInput("DesiredZoneName", atts.getName());
        message.setInput("DesiredIcon", atts.getIcon());
        this.execute(message);
    }
}

