/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.ConnectionManagerService;
import org.tensin.sonos.control.ContentDirectoryService;

public class MediaServerDevice {
    private final RemoteDevice dev;
    private final ContentDirectoryService contentDirectory;
    private final ConnectionManagerService connectionManager;

    protected MediaServerDevice(UpnpService upnpService, RemoteDevice dev) {
        if (dev != null && dev.getType() != null && !dev.getType().toString().equals("urn:schemas-upnp-org:device:MediaServer:1")) {
            throw new IllegalArgumentException("Device must be media server, not " + dev.getType());
        }
        this.dev = dev;
        this.contentDirectory = new ContentDirectoryService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:ContentDirectory:1"));
        this.connectionManager = new ConnectionManagerService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:ConnectionManager:1"));
    }

    public void dispose() {
        this.contentDirectory.dispose();
        this.connectionManager.dispose();
    }

    public ConnectionManagerService getConnectionManagerService() {
        return this.connectionManager;
    }

    public ContentDirectoryService getContentDirectoryService() {
        return this.contentDirectory;
    }

    public RemoteDevice getRemoteDevice() {
        return this.dev;
    }
}

