/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.control;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.control.AVTransportService;
import org.tensin.sonos.control.AbstractAudioInService;
import org.tensin.sonos.control.AbstractService;
import org.tensin.sonos.control.AlarmClockService;
import org.tensin.sonos.control.DevicePropertiesService;
import org.tensin.sonos.control.MediaRendererDevice;
import org.tensin.sonos.control.MediaServerDevice;
import org.tensin.sonos.control.SystemPropertiesService;
import org.tensin.sonos.control.ZoneGroupManagementService;
import org.tensin.sonos.control.ZoneGroupTopologyService;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.SeekTargetFactory;
import org.tensin.sonos.model.TransportInfo;

public class ZonePlayer {
    private final RemoteDevice dev;
    private final MediaServerDevice mediaServer;
    private final MediaRendererDevice mediaRenderer;
    private final AlarmClockService alarm;
    private final AbstractAudioInService audioIn;
    private final DevicePropertiesService deviceProperties;
    private final SystemPropertiesService systemProperties;
    private final ZoneGroupTopologyService zoneGroupTopology;
    private final ZoneGroupManagementService zoneGroupManagement;
    private InetAddress ip;
    private final int port;

    protected static RemoteDevice findChildDevice(RemoteDevice device, String type) {
        for (RemoteDevice remoteDevice : device.getEmbeddedDevices()) {
            if (!remoteDevice.getType().toString().equalsIgnoreCase(type)) continue;
            return remoteDevice;
        }
        return null;
    }

    public ZonePlayer(UpnpService upnpService, RemoteDevice dev) {
        if (!dev.getType().toString().equals("urn:schemas-upnp-org:device:ZonePlayer:1")) {
            throw new IllegalArgumentException("dev must be a sonos device, not [" + dev.getType() + "]");
        }
        this.dev = dev;
        try {
            this.ip = InetAddress.getByName(((RemoteDeviceIdentity)dev.getIdentity()).getDescriptorURL().getHost());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.port = ((RemoteDeviceIdentity)dev.getIdentity()).getDescriptorURL().getPort();
        this.mediaServer = new MediaServerDevice(upnpService, ZonePlayer.findChildDevice(dev, "urn:schemas-upnp-org:device:MediaServer:1"));
        this.mediaRenderer = new MediaRendererDevice(upnpService, ZonePlayer.findChildDevice(dev, "urn:schemas-upnp-org:device:MediaRenderer:1"));
        this.alarm = new AlarmClockService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:AlarmClock:1"));
        this.audioIn = AbstractAudioInService.buildAudioInService(upnpService, dev);
        this.deviceProperties = new DevicePropertiesService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:DeviceProperties:1"));
        this.systemProperties = new SystemPropertiesService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:SystemProperties:1"));
        this.zoneGroupTopology = new ZoneGroupTopologyService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:ZoneGroupTopology:1"));
        this.zoneGroupManagement = new ZoneGroupManagementService(upnpService, AbstractService.findService(dev, "urn:schemas-upnp-org:service:GroupManagement:1"));
    }

    public URL appendUrl(String url) throws MalformedURLException {
        return new URL("http", this.getIP().getHostAddress(), this.getPort(), url);
    }

    public void dispose() {
        this.mediaServer.dispose();
        this.mediaRenderer.dispose();
        this.alarm.dispose();
        this.audioIn.dispose();
        this.deviceProperties.dispose();
        this.systemProperties.dispose();
        this.zoneGroupTopology.dispose();
        this.zoneGroupManagement.dispose();
    }

    public void enqueueAndPlayEntry(Entry entry) throws SonosException {
        this.playQueueEntry(this.enqueueEntry(entry));
    }

    public int enqueueEntry(Entry entry) {
        AVTransportService serv = this.getMediaRendererDevice().getAvTransportService();
        int index = serv.addToQueue(entry);
        return index;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof ZonePlayer) {
            ZonePlayer zp = (ZonePlayer)obj;
            return ((RemoteDeviceIdentity)zp.getRootDevice().getIdentity()).getUdn().getIdentifierString().equals(((RemoteDeviceIdentity)this.getRootDevice().getIdentity()).getUdn().getIdentifierString());
        }
        return false;
    }

    public AlarmClockService getAlarmService() {
        return this.alarm;
    }

    public AbstractAudioInService getAudioInService() {
        return this.audioIn;
    }

    public DevicePropertiesService getDevicePropertiesService() {
        return this.deviceProperties;
    }

    public String getId() {
        return ((RemoteDeviceIdentity)this.getRootDevice().getIdentity()).getUdn().getIdentifierString().substring(5);
    }

    public InetAddress getIP() {
        return this.ip;
    }

    public MediaRendererDevice getMediaRendererDevice() {
        return this.mediaRenderer;
    }

    public MediaServerDevice getMediaServerDevice() {
        return this.mediaServer;
    }

    public int getPort() {
        return this.port;
    }

    public RemoteDevice getRootDevice() {
        return this.dev;
    }

    public SystemPropertiesService getSystemPropertiesService() {
        return this.systemProperties;
    }

    public ZoneGroupManagementService getZoneGroupManagementService() {
        return this.zoneGroupManagement;
    }

    public ZoneGroupTopologyService getZoneGroupTopologyService() {
        return this.zoneGroupTopology;
    }

    public int hashCode() {
        return ((RemoteDeviceIdentity)this.getRootDevice().getIdentity()).getUdn().getIdentifierString().hashCode();
    }

    public void playQueueEntry(int index) throws SonosException {
        AVTransportService serv = this.getMediaRendererDevice().getAvTransportService();
        if (!serv.getMediaInfo().getCurrentURI().startsWith("x-rincon-queue:")) {
            serv.setAvTransportUriToQueue(this.getId());
        }
        serv.seek(SeekTargetFactory.createTrackSeekTarget(index));
        if (!serv.getTransportInfo().getState().equals((Object)TransportInfo.TransportState.PLAYING)) {
            serv.play();
        }
    }
}

