/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.ISonosIndexer;
import org.tensin.sonos.SonosException;
import org.tensin.sonos.SonosIndexer;
import org.tensin.sonos.control.BrowseHandle;
import org.tensin.sonos.control.EntryCallback;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.MusicLibraryListener;
import org.tensin.sonos.model.MusicLibraryModel;

public class MusicLibrary
implements MusicLibraryModel {
    private ISonosIndexer sonosIndexer = SonosIndexer.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(MusicLibrary.class);
    protected final List<Entry> entries = new ArrayList<Entry>();
    private int reportedSize;
    private final List<MusicLibraryListener> listeners = new ArrayList<MusicLibraryListener>();
    private BrowseHandle browser;

    public MusicLibrary(ZonePlayer zone) {
        this(zone, "A:");
    }

    public MusicLibrary(ZonePlayer zone, Entry entry) {
        String id = entry != null ? entry.getId() : "A:";
        this.browser = this.loadEntries(zone, id);
    }

    public MusicLibrary(ZonePlayer zone, String type) {
        this.browser = this.loadEntries(zone, type);
    }

    protected void addEntries(Collection<Entry> newEntries) {
        int oldSize = this.entries.size();
        this.entries.addAll(newEntries);
        this.fireEntriesAdded(oldSize, this.entries.size() - 1);
    }

    @Override
    public void addListener(MusicLibraryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void dispose() {
        if (this.browser != null) {
            this.browser.cancel();
        }
        this.removeListeners();
    }

    protected void fireEntriesAdded(int start, int end) {
        for (MusicLibraryListener listener : this.listeners) {
            listener.entriesAdded(start, end);
        }
    }

    protected void fireSizeChanged() {
        for (MusicLibraryListener listener : this.listeners) {
            listener.sizeChanged();
        }
    }

    @Override
    public Entry getEntryAt(int index) {
        return this.entries.get(index);
    }

    @Override
    public int getSize() {
        return Math.max(this.entries.size(), this.reportedSize);
    }

    public ISonosIndexer getSonosIndexer() {
        return this.sonosIndexer;
    }

    @Override
    public boolean hasEntryFor(int index) {
        return index < this.entries.size();
    }

    @Override
    public int indexOf(Entry entry) {
        return this.entries.indexOf(entry);
    }

    protected BrowseHandle loadEntries(ZonePlayer zone, String type) {
        return zone.getMediaServerDevice().getContentDirectoryService().getAllEntriesAsync(new MusicLibraryEntryCallback(), type);
    }

    @Override
    public void removeListener(MusicLibraryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeListeners() {
        this.listeners.clear();
    }

    protected void setReportedSize(int count) {
        this.reportedSize = count;
        this.fireSizeChanged();
    }

    public void setSonosIndexer(ISonosIndexer sonosIndexer) {
        this.sonosIndexer = sonosIndexer;
    }

    public class MusicLibraryEntryCallback
    implements EntryCallback {
        @Override
        public void addEntries(BrowseHandle handle, Collection<Entry> entries) {
            MusicLibrary.this.addEntries(entries);
            LOGGER.info("Indexing [" + entries.size() + "] entries");
            for (Entry entry : entries) {
                try {
                    MusicLibrary.this.sonosIndexer.index(entry);
                }
                catch (SonosException ex) {
                    LOGGER.error("Can't index element", ex);
                }
            }
        }

        @Override
        public void retrievalComplete(BrowseHandle handle, boolean completedSuccessfully) {
            if (handle == MusicLibrary.this.browser) {
                MusicLibrary.this.browser = null;
            }
        }

        @Override
        public void updateCount(BrowseHandle handle, int count) {
            MusicLibrary.this.setReportedSize(count);
        }
    }
}

