/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.model;

import java.util.ArrayList;
import java.util.List;
import org.tensin.sonos.control.ZonePlayer;
import org.tensin.sonos.model.ZonePlayerModelListener;

public class ZonePlayerModel {
    private final List<ZonePlayer> zonePlayers = new ArrayList<ZonePlayer>();
    private final List<ZonePlayerModelListener> listeners = new ArrayList<ZonePlayerModelListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZonePlayer(ZonePlayer zp) {
        List<Object> list = this.zonePlayers;
        synchronized (list) {
            this.zonePlayers.add(zp);
        }
        list = this.listeners;
        synchronized (list) {
            for (ZonePlayerModelListener l : this.listeners) {
                l.zonePlayerAdded(zp, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addZonePlayerModelListener(ZonePlayerModelListener l) {
        List<ZonePlayerModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZonePlayer get(int index) {
        List<ZonePlayer> list = this.zonePlayers;
        synchronized (list) {
            try {
                return this.zonePlayers.get(index);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZonePlayer> getAllZones() {
        List<ZonePlayer> list = this.zonePlayers;
        synchronized (list) {
            return this.zonePlayers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZonePlayer getById(String id) {
        List<ZonePlayer> list = this.zonePlayers;
        synchronized (list) {
            for (ZonePlayer zp : this.zonePlayers) {
                if (!zp.getId().equals(id)) continue;
                return zp;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOf(ZonePlayer zp) {
        List<ZonePlayer> list = this.zonePlayers;
        synchronized (list) {
            return this.zonePlayers.indexOf(zp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        List<ZonePlayer> list = this.zonePlayers;
        synchronized (list) {
            return this.zonePlayers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ZonePlayer zp) {
        List<Object> list = this.zonePlayers;
        synchronized (list) {
            this.zonePlayers.remove(zp);
        }
        list = this.listeners;
        synchronized (list) {
            for (ZonePlayerModelListener l : this.listeners) {
                l.zonePlayerRemoved(zp, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeZonePlayerModelListener(ZonePlayerModelListener l) {
        List<ZonePlayerModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }
}

