/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.xml;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AVTransportEventHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AVTransportEventHandler.class);
    private final Map<AVTransportEventType, String> changes = new HashMap<AVTransportEventType, String>();

    public Map<AVTransportEventType, String> getChanges() {
        return this.changes;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            AVTransportEventType type = AVTransportEventType.valueOf(localName);
            this.changes.put(type, atts.getValue("val"));
        }
        catch (IllegalArgumentException e) {
            LOGGER.info(localName + " is not defined in EventType. ");
        }
    }

    public static enum AVTransportEventType {
        TransportState,
        CurrentPlayMode,
        CurrentCrossfadeMode,
        NumberOfTracks,
        CurrentTrack,
        CurrentSection,
        CurrentTrackURI,
        CurrentTrackDuration,
        CurrentTrackMetaData,
        PlaybackStorageMedium,
        AVTransportURI,
        AVTransportURIMetaData,
        CurrentTransportActions,
        TransportStatus,
        SleepTimerGeneration,
        AlarmRunning,
        SnoozeRunning,
        RestartPending,
        TransportPlaySpeed,
        CurrentMediaDuration,
        RecordStorageMedium,
        PossiblePlaybackStorageMedia,
        PossibleRecordStorageMedia,
        RecordMediumWriteStatus,
        CurrentRecordQualityMode,
        PossibleRecordQualityModes,
        NextAVTransportURI,
        NextAVTransportURIMetaData,
        Event,
        InstanceID,
        NextTrackURI,
        NextTrackMetaData,
        EnqueuedTransportURI,
        EnqueuedTransportURIMetaData;

    }
}

