/*
 * Decompiled with CFR 0.152.
 */
package org.tensin.sonos.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensin.sonos.model.Entry;
import org.tensin.sonos.model.TrackMetaData;
import org.tensin.sonos.model.ZoneGroupState;
import org.tensin.sonos.xml.AVTransportEventHandler;
import org.tensin.sonos.xml.EntryHandler;
import org.tensin.sonos.xml.RenderingControlEventHandler;
import org.tensin.sonos.xml.TrackMetaDataHandler;
import org.tensin.sonos.xml.ZoneGroupStateHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ResultParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultParser.class);

    public static List<Entry> getEntriesFromStringResult(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        EntryHandler handler = new EntryHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse entries: ", e);
        }
        return handler.getArtists();
    }

    public static ZoneGroupState getGroupStateFromResult(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        ZoneGroupStateHandler handler = new ZoneGroupStateHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse group state: ", e);
        }
        return new ZoneGroupState(handler.getGroups());
    }

    public static Map<AVTransportEventHandler.AVTransportEventType, String> parseAVTransportEvent(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        AVTransportEventHandler handler = new AVTransportEventHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse AV Transport Event: ", e);
        }
        return handler.getChanges();
    }

    public static Map<RenderingControlEventHandler.RenderingControlEventType, String> parseRenderingControlEvent(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        RenderingControlEventHandler handler = new RenderingControlEventHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse Rendering Control event: ", e);
        }
        return handler.getChanges();
    }

    public static TrackMetaData parseTrackMetaData(String xml) throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        TrackMetaDataHandler handler = new TrackMetaDataHandler();
        reader.setContentHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException e) {
            LOGGER.error("Could not parse AV Transport Event: ", e);
        }
        return handler.getMetaData();
    }
}

