/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import org.controlsfx.DialogResources;

public class Alert
extends Dialog<ButtonType> {
    private WeakReference<DialogPane> dialogPaneRef;
    private boolean installingDefaults = false;
    private boolean hasCustomButtons = false;
    private boolean hasCustomTitle = false;
    private boolean hasCustomHeaderText = false;
    private final InvalidationListener headerTextListener = o -> {
        if (!this.installingDefaults) {
            this.hasCustomHeaderText = true;
        }
    };
    private final InvalidationListener titleListener = o -> {
        if (!this.installingDefaults) {
            this.hasCustomTitle = true;
        }
    };
    private final ListChangeListener<ButtonType> buttonsListener = change -> {
        if (!this.installingDefaults) {
            this.hasCustomButtons = true;
        }
    };
    private final ObjectProperty<AlertType> alertType = new SimpleObjectProperty<AlertType>(null){
        final String[] styleClasses;
        {
            this.styleClasses = new String[]{"information", "warning", "error", "confirmation"};
        }

        protected void invalidated() {
            DialogPane dialogPane;
            String newTitle = "";
            String newHeader = "";
            String styleClass = "";
            Object[] newButtons = new ButtonType[]{ButtonType.OK};
            switch (Alert.this.getAlertType()) {
                case NONE: {
                    newButtons = new ButtonType[]{};
                    break;
                }
                case INFORMATION: {
                    newTitle = DialogResources.getString("Dialog.info.title");
                    newHeader = DialogResources.getString("Dialog.info.header");
                    styleClass = "information";
                    break;
                }
                case WARNING: {
                    newTitle = DialogResources.getString("Dialog.warning.title");
                    newHeader = DialogResources.getString("Dialog.warning.header");
                    styleClass = "warning";
                    break;
                }
                case ERROR: {
                    newTitle = DialogResources.getString("Dialog.error.title");
                    newHeader = DialogResources.getString("Dialog.error.header");
                    styleClass = "error";
                    break;
                }
                case CONFIRMATION: {
                    newTitle = DialogResources.getString("Dialog.confirm.title");
                    newHeader = DialogResources.getString("Dialog.confirm.header");
                    styleClass = "confirmation";
                    newButtons = new ButtonType[]{ButtonType.OK, ButtonType.CANCEL};
                }
            }
            Alert.this.installingDefaults = true;
            if (!Alert.this.hasCustomTitle) {
                Alert.this.setTitle(newTitle);
            }
            if (!Alert.this.hasCustomHeaderText) {
                Alert.this.setHeaderText(newHeader);
            }
            if (!Alert.this.hasCustomButtons) {
                Alert.this.getButtonTypes().setAll(newButtons);
            }
            if ((dialogPane = Alert.this.getDialogPane()) != null) {
                ArrayList<String> toRemove = new ArrayList<String>(Arrays.asList(this.styleClasses));
                toRemove.remove(styleClass);
                dialogPane.getStyleClass().removeAll(toRemove);
                if (!dialogPane.getStyleClass().contains((Object)styleClass)) {
                    dialogPane.getStyleClass().add((Object)styleClass);
                }
            }
            Alert.this.installingDefaults = false;
        }
    };

    public Alert(@NamedArg(value="alertType") AlertType alertType) {
        this(alertType, "", new ButtonType[0]);
    }

    public Alert(@NamedArg(value="alertType") AlertType alertType, @NamedArg(value="contentText") String contentText, ButtonType ... buttons) {
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.setContentText(contentText);
        this.getDialogPane().getStyleClass().add((Object)"alert");
        this.dialogPaneRef = new WeakReference<DialogPane>(dialogPane);
        boolean bl = this.hasCustomButtons = buttons != null && buttons.length > 0;
        if (this.hasCustomButtons) {
            for (ButtonType btnType : buttons) {
                dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{btnType});
            }
        }
        this.setAlertType(alertType);
        this.dialogPaneProperty().addListener(o -> this.updateListeners());
        this.titleProperty().addListener(this.titleListener);
        this.updateListeners();
    }

    public final AlertType getAlertType() {
        return (AlertType)((Object)this.alertType.get());
    }

    public final void setAlertType(AlertType alertType) {
        this.alertType.setValue((Object)alertType);
    }

    public final ObjectProperty<AlertType> alertTypeProperty() {
        return this.alertType;
    }

    public final ObservableList<ButtonType> getButtonTypes() {
        return this.getDialogPane().getButtonTypes();
    }

    private void updateListeners() {
        DialogPane newPane;
        DialogPane oldPane = (DialogPane)((Object)this.dialogPaneRef.get());
        if (oldPane != null) {
            oldPane.headerTextProperty().removeListener(this.headerTextListener);
            oldPane.getButtonTypes().removeListener(this.buttonsListener);
        }
        if ((newPane = this.getDialogPane()) != null) {
            newPane.headerTextProperty().addListener(this.headerTextListener);
            newPane.getButtonTypes().addListener(this.buttonsListener);
        }
        this.dialogPaneRef = new WeakReference<DialogPane>(newPane);
    }

    public static enum AlertType {
        NONE,
        INFORMATION,
        WARNING,
        CONFIRMATION,
        ERROR;

    }
}

