/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.NamedArg;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.Dialog;

public class DialogEvent
extends Event {
    private static final long serialVersionUID = 20140716L;
    public static final EventType<DialogEvent> ANY = new EventType(Event.ANY, "DIALOG");
    public static final EventType<DialogEvent> DIALOG_SHOWING = new EventType(ANY, "DIALOG_SHOWING");
    public static final EventType<DialogEvent> DIALOG_SHOWN = new EventType(ANY, "DIALOG_SHOWN");
    public static final EventType<DialogEvent> DIALOG_HIDING = new EventType(ANY, "DIALOG_HIDING");
    public static final EventType<DialogEvent> DIALOG_HIDDEN = new EventType(ANY, "DIALOG_HIDDEN");
    public static final EventType<DialogEvent> DIALOG_CLOSE_REQUEST = new EventType(ANY, "DIALOG_CLOSE_REQUEST");

    public DialogEvent(@NamedArg(value="source") Dialog<?> source, @NamedArg(value="eventType") EventType<? extends Event> eventType) {
        super(source, source, eventType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DialogEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        return sb.append("]").toString();
    }

    public DialogEvent copyFor(Object newSource, EventTarget newTarget) {
        return (DialogEvent)super.copyFor(newSource, newTarget);
    }

    public DialogEvent copyFor(Object newSource, EventTarget newTarget, EventType<DialogEvent> type) {
        DialogEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<DialogEvent> getEventType() {
        return super.getEventType();
    }
}

